/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools;

import com.tvd12.ezyfox.io.EzyStrings;
import java.util.HashMap;
import java.util.Map;
import org.youngmonkeys.ezyplatform.sdk.tools.Command;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.Arguments;
import org.youngmonkeys.ezyplatform.sdk.tools.exception.HandleCommandFailedException;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AddLicenseCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.CommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.CreateProjectCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.ExportCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.ExportJavaDocsCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.HelpCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.LinkCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.PackCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.RemoveLowerVersionLibsCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.SetVersionCommandHandler;

public class SdkTools {
    private final Map<Command, CommandHandler> handlers = this.defaultHandlers();

    private SdkTools() {
    }

    private void run(Command command, String[] args) {
        try {
            CommandHandler handler = this.handlers.get((Object)command);
            Arguments arguments = handler.parse(args);
            String result = handler.handle(arguments);
            this.println(result);
        }
        catch (HandleCommandFailedException e) {
            this.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void println(String msg) {
        if (EzyStrings.isNotBlank((String)msg)) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        Command command = Command.of(args[0]);
        if (command == null) {
            for (Command cmd : Command.values()) {
                if (!cmd.getName().contains(args[0].toLowerCase())) continue;
                System.out.println("Command: '" + args[0] + "' not found, do you mean: " + cmd.getName() + "?");
                return;
            }
            System.out.println("Command: '" + args[0] + "' not found, run 'help' to get the command list");
            return;
        }
        String[] commandArgs = new String[]{};
        if (args.length > 1) {
            commandArgs = new String[args.length - 1];
            System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);
        }
        new SdkTools().run(command, commandArgs);
    }

    private Map<Command, CommandHandler> defaultHandlers() {
        HashMap<Command, CommandHandler> map = new HashMap<Command, CommandHandler>();
        map.put(Command.CREATE_PROJECT, new CreateProjectCommandHandler());
        map.put(Command.CREATE_PROJECT_1, new CreateProjectCommandHandler());
        map.put(Command.CREATE_PROJECT_2, new CreateProjectCommandHandler());
        map.put(Command.CREATE_PROJECT_3, new CreateProjectCommandHandler());
        map.put(Command.EXPORT, new ExportCommandHandler());
        map.put(Command.EXPORT_1, new ExportCommandHandler());
        map.put(Command.EXPORT_2, new ExportCommandHandler());
        map.put(Command.EXPORT_JAVA_DOCS, new ExportJavaDocsCommandHandler());
        map.put(Command.EXPORT_JAVA_DOCS_1, new ExportJavaDocsCommandHandler());
        map.put(Command.EXPORT_JAVA_DOCS_2, new ExportJavaDocsCommandHandler());
        map.put(Command.HELP, new HelpCommandHandler());
        map.put(Command.HELP_1, new HelpCommandHandler());
        map.put(Command.HELP_2, new HelpCommandHandler());
        map.put(Command.HELP_3, new HelpCommandHandler());
        map.put(Command.LINK, new LinkCommandHandler());
        map.put(Command.LINK_1, new LinkCommandHandler());
        map.put(Command.LINK_2, new LinkCommandHandler());
        map.put(Command.PACKAGE, new PackCommandHandler());
        map.put(Command.PACKAGE_1, new PackCommandHandler());
        map.put(Command.PACKAGE_2, new PackCommandHandler());
        map.put(Command.ADD_LICENSE_1, new AddLicenseCommandHandler());
        map.put(Command.ADD_LICENSE_2, new AddLicenseCommandHandler());
        map.put(Command.SET_VERSION, new SetVersionCommandHandler());
        map.put(Command.SET_VERSION_1, new SetVersionCommandHandler());
        map.put(Command.SET_VERSION_2, new SetVersionCommandHandler());
        map.put(Command.REMOVE_LOWER_VERSION_LIBS, new RemoveLowerVersionLibsCommandHandler());
        return map;
    }
}

