/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import com.tvd12.ezyfox.io.EzyStrings;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.SetVersionArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.constant.SdkConstants;
import org.youngmonkeys.ezyplatform.sdk.tools.exception.HandleCommandFailedException;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PomXmlReaders;

public class SetVersionCommandHandler
extends AbstractCommandHandler<SetVersionArguments> {
    @Override
    public String handle(SetVersionArguments args) throws Exception {
        List childPomFiles;
        String targetProjectFolder = args.getTargetProjectFolder();
        Path projectDir = Paths.get(EzyStrings.isBlank((String)targetProjectFolder) ? "" : targetProjectFolder, new String[0]);
        Path parentPomFile = projectDir.resolve("pom.xml");
        if (!Files.exists(parentPomFile, new LinkOption[0])) {
            throw new IOException("pom.xml file not found");
        }
        String currentDirName = projectDir.toAbsolutePath().getFileName().toString();
        String parentArtifactId = PomXmlReaders.getProjectArtifactIdOrThrow(parentPomFile.toFile());
        try (Stream<Path> paths = Files.walk(projectDir, 1, new FileVisitOption[0]);){
            childPomFiles = paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> !p.endsWith(projectDir)).filter(p -> {
                String folderName = p.getFileName().toString();
                if (folderName.startsWith(currentDirName) || folderName.startsWith(parentArtifactId)) {
                    Path pomFile = p.resolve("pom.xml");
                    return Files.exists(pomFile, new LinkOption[0]);
                }
                return false;
            }).map(p -> p.resolve("pom.xml")).collect(Collectors.toList());
        }
        int pomFileCount = childPomFiles.size() + 1;
        String version = args.getVersion();
        System.out.println("found " + pomFileCount + " to set version");
        this.setVersion(parentPomFile, false, version);
        System.out.println("1. set version: " + version + " for " + parentPomFile);
        for (int i = 0; i < childPomFiles.size(); ++i) {
            Path pomFile = (Path)childPomFiles.get(i);
            this.setVersion(pomFile, true, version);
            Path modulePropertiesFile = pomFile.getParent().resolve("module.properties");
            if (Files.exists(modulePropertiesFile, new LinkOption[0])) {
                this.setModuleVersion(modulePropertiesFile, version);
            }
            System.out.println(i + 2 + ". set version: " + version + " for " + pomFile);
        }
        return "set version: " + version + " for " + pomFileCount + " files successfully";
    }

    private void setVersion(Path pomFile, boolean includeParentPom, String version) throws IOException {
        List newLines;
        int maxSetCount = includeParentPom ? 2 : 1;
        AtomicInteger setCount = new AtomicInteger();
        AtomicBoolean allowToSetVersion = new AtomicBoolean(true);
        try (Stream<String> lines = Files.lines(pomFile);){
            newLines = lines.map(line -> {
                block6: {
                    block7: {
                        block5: {
                            if (setCount.get() >= maxSetCount) {
                                return line;
                            }
                            if (!line.contains("<parent>")) break block5;
                            if (includeParentPom) break block6;
                            allowToSetVersion.set(false);
                            break block6;
                        }
                        if (!line.contains("</parent>")) break block7;
                        if (includeParentPom) break block6;
                        allowToSetVersion.set(true);
                        break block6;
                    }
                    if (line.contains("<version>")) {
                        if (allowToSetVersion.get()) {
                            setCount.incrementAndGet();
                            String currentVersion = PomXmlReaders.getCurrentVersion(line);
                            return line.replace(currentVersion, version);
                        }
                    } else {
                        for (String tag : SdkConstants.PARENT_TAGS_IN_POM_FILE) {
                            if (!line.contains(tag)) continue;
                            setCount.set(maxSetCount);
                            break;
                        }
                    }
                }
                return line;
            }).collect(Collectors.toList());
        }
        Files.write(pomFile, newLines, new OpenOption[0]);
    }

    public void setModuleVersion(Path modulePropertiesFile, String version) throws Exception {
        try (Stream<String> lines = Files.lines(modulePropertiesFile);){
            List newLines = lines.map(line -> {
                if (line.contains("version") && line.contains("=")) {
                    return "version=" + version;
                }
                return line;
            }).collect(Collectors.toList());
            Files.write(modulePropertiesFile, newLines, new OpenOption[0]);
        }
    }

    @Override
    public SetVersionArguments parse(String[] args) {
        if (args.length == 0) {
            throw new HandleCommandFailedException("missing version name, run help to see how to set version");
        }
        String targetProjectFolder = null;
        String version = args[0];
        if (args.length > 1) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-t") && i < args.length - 1) {
                    targetProjectFolder = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-v") && i < args.length - 1) {
                    version = args[i + 1];
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("unknown option: " + args[i] + ", run help to see how to create a project");
            }
        }
        return new SetVersionArguments(targetProjectFolder, version);
    }
}

