/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.exception.HandleCommandFailedException;
import org.youngmonkeys.ezyplatform.sdk.tools.io.LocalPropertiesReader;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ModulePropertiesReader;

public final class FileProxy {
    private FileProxy() {
    }

    public static List<String> readContentLines(String filePath) {
        try {
            return FileProxy.readLines(filePath).stream().filter(line -> line.length() > 0 && !line.trim().startsWith("#")).collect(Collectors.toList());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(String filePath) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileProxy.getInputstream(filePath)));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static InputStream getInputstream(String filePath) throws IOException {
        InputStream inputStream = FileProxy.class.getResourceAsStream(filePath);
        if (inputStream == null) {
            inputStream = FileProxy.class.getResourceAsStream("/" + filePath);
        }
        if (inputStream == null) {
            inputStream = Files.newInputStream(new File(filePath).toPath(), new OpenOption[0]);
        }
        return inputStream;
    }

    public static String getEzyPlatformHome() {
        LocalPropertiesReader localPropertiesReader = new LocalPropertiesReader();
        return localPropertiesReader.getEzyPlatformHome(null);
    }

    public static Path getProjectPomFileOrThrow(String projectFolder) {
        Path projectPomFilePath = Paths.get(projectFolder, "pom.xml");
        if (!Files.exists(projectPomFilePath, new LinkOption[0])) {
            throw new HandleCommandFailedException("invalid project location, a maven project must have a pom.xml file");
        }
        return projectPomFilePath;
    }

    public static Map<String, Map<String, String>> getPomFiles(String projectFolder) throws Exception {
        HashMap<String, Map<String, String>> pomFilePathByFolderMapByModuleType = new HashMap<String, Map<String, String>>();
        Path rootPath = Paths.get(projectFolder, new String[0]);
        try (Stream<Path> stream = Files.walk(rootPath, 1, new FileVisitOption[0]);){
            List<Path> paths = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.resolve("pom.xml")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
            paths.forEach(path -> {
                String type = ModulePropertiesReader.getModuleType(rootPath);
                Path parent = path.getParent();
                if (parent != null && !parent.equals(rootPath)) {
                    type = ModulePropertiesReader.getModuleType(parent);
                }
                String moduleTypeFolder = parent == null ? projectFolder : parent.getFileName().toString();
                pomFilePathByFolderMapByModuleType.computeIfAbsent(type, k -> new HashMap()).put(moduleTypeFolder, path.toString());
            });
            HashMap<String, Map<String, String>> hashMap = pomFilePathByFolderMapByModuleType;
            return hashMap;
        }
    }

    public static Map<ModuleType, Map<String, String>> getInclusivePomFileMap(String projectFolder, Set<ModuleType> moduleTypes) throws Exception {
        Map<String, Map<String, String>> pomFileByFolderMapByModuleType = FileProxy.getPomFiles(projectFolder);
        HashMap<ModuleType, Map<String, String>> answer = new HashMap<ModuleType, Map<String, String>>();
        for (ModuleType moduleType : moduleTypes) {
            String moduleTypeName = moduleType.getName();
            Map<String, String> pomFiles = pomFileByFolderMapByModuleType.get(moduleTypeName);
            if (pomFiles == null) continue;
            answer.put(moduleType, pomFiles);
        }
        return answer;
    }
}

