/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.properties.file.mapping.PropertiesMapper;
import com.tvd12.properties.file.reader.BaseFileReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleProperties;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;

public class ModulePropertiesReader {
    public ModuleProperties read(String module) {
        String modulePropertiesFile = this.getModulePropertiesFile(module);
        ModuleProperties moduleProperties = (ModuleProperties)new PropertiesMapper().file(modulePropertiesFile).map(ModuleProperties.class);
        String typeName = moduleProperties.getType();
        ModuleType type = ModuleType.of(typeName);
        if (type == null) {
            throw new IllegalArgumentException("must set type=web|web-plugin|socket-plugin|socket-app|admin-plugin in module.properties file");
        }
        moduleProperties.setTypeEnum(type);
        String packageName = moduleProperties.getPackageName();
        if (packageName == null) {
            throw new IllegalArgumentException("must set package=<Package Name> in module.properties file");
        }
        String version = moduleProperties.getVersion();
        if (version == null) {
            throw new IllegalArgumentException("must set version=<Version> in module.properties file");
        }
        String projectName = moduleProperties.getProjectName();
        if (projectName == null) {
            throw new IllegalArgumentException("must set project_name=<Project Name> in module.properties file");
        }
        if (projectName.contains("  ")) {
            throw new IllegalStateException("invalid project_name: contain multi spaces");
        }
        if (!projectName.matches("^[a-zA-Z0-9_.#\\s]{3,64}$")) {
            throw new IllegalStateException("project_name must match pattern: ^[a-zA-Z0-9_.#\\s]{3,64}$");
        }
        String targetModuleName = EzyStrings.toDashCase((String)projectName.toLowerCase().replace(' ', '-'));
        moduleProperties.setTargetModuleName(targetModuleName);
        return moduleProperties;
    }

    private String getModulePropertiesFile(String module) {
        File file = (module != null ? Paths.get(module, "module.properties") : Paths.get("module.properties", new String[0])).toFile();
        if (!file.exists()) {
            System.err.println("module.properties not found");
        }
        return file.toString();
    }

    public static String getModuleType(Path moduleFolderPath) {
        String answer = null;
        Path modulePropertiesFile = moduleFolderPath.resolve("module.properties");
        if (Files.exists(modulePropertiesFile, new LinkOption[0])) {
            Properties properties = new BaseFileReader().read(modulePropertiesFile.toFile());
            answer = properties.getProperty("type");
        }
        return answer != null ? answer : "common";
    }
}

