/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.function.EzyToObject;
import com.tvd12.ezyfox.io.EzyDataConverter;
import com.tvd12.ezyfox.io.EzyDates;
import com.tvd12.ezyfox.io.EzyNumbersConverter;
import com.tvd12.ezyfox.io.EzyStringConverter;
import com.tvd12.ezyfox.io.EzyValueConverter;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class EzySimpleValueConverter
extends EzyLoggable
implements EzyValueConverter {
    protected final Map<Class, EzyToObject> transformers = this.defaultTransformers();

    public static EzySimpleValueConverter getSingleton() {
        return EzySingletonValueConverter.getInstance();
    }

    @Override
    public <T> T convert(Object value, Class<T> outType) {
        if (value == null) {
            return null;
        }
        EzyToObject transformer = this.transformers.get(outType);
        if (transformer != null) {
            return (T)transformer.transform(value);
        }
        if (outType.isEnum()) {
            return Enum.valueOf(outType, value.toString());
        }
        return (T)value;
    }

    protected IllegalArgumentException newTransformerException(Class<?> type, Object value) {
        return new IllegalArgumentException("can't transform: " + value + " to " + type.getSimpleName() + " value");
    }

    private Map<Class, EzyToObject> defaultTransformers() {
        HashMap<Class, EzyToObject> answer = new HashMap<Class, EzyToObject>();
        this.addOtherTransformers(answer);
        this.addWrapperTransformers(answer);
        this.addPrimitiveTransformers(answer);
        this.addWrapperArrayTransformers(answer);
        this.addPrimitiveArrayTransformers(answer);
        this.addTwoDimensionsWrapperArrayTransformers(answer);
        this.addTwoDimensionsPrimitiveArrayTransformers(answer);
        return answer;
    }

    protected void addPrimitiveTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean.TYPE, value -> {
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw this.newTransformerException(Boolean.TYPE, value);
        });
        answer.put(Byte.TYPE, value -> {
            if (value instanceof String) {
                return Byte.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            throw this.newTransformerException(Byte.TYPE, value);
        });
        answer.put(Character.TYPE, value -> {
            if (value instanceof Character) {
                return (Character)value;
            }
            if (value instanceof Number) {
                return Character.valueOf((char)((Number)value).byteValue());
            }
            if (value instanceof String) {
                return Character.valueOf(EzyStringConverter.stringToChar((String)value));
            }
            throw this.newTransformerException(Character.TYPE, value);
        });
        answer.put(Double.TYPE, value -> {
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            throw this.newTransformerException(Double.TYPE, value);
        });
        answer.put(Float.TYPE, value -> {
            if (value instanceof String) {
                return Float.valueOf((String)value);
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            throw this.newTransformerException(Float.TYPE, value);
        });
        answer.put(Integer.TYPE, value -> {
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            throw this.newTransformerException(Integer.TYPE, value);
        });
        answer.put(Long.TYPE, value -> {
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            throw this.newTransformerException(Long.TYPE, value);
        });
        answer.put(Short.TYPE, value -> {
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            throw this.newTransformerException(Short.TYPE, value);
        });
    }

    protected void addWrapperTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean.class, value -> {
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw this.newTransformerException(Boolean.class, value);
        });
        answer.put(Byte.class, value -> {
            if (value instanceof String) {
                return Byte.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            throw this.newTransformerException(Byte.class, value);
        });
        answer.put(Character.class, value -> {
            if (value instanceof Character) {
                return (Character)value;
            }
            if (value instanceof Number) {
                return Character.valueOf((char)((Number)value).byteValue());
            }
            if (value instanceof String) {
                return Character.valueOf(EzyStringConverter.stringToChar((String)value));
            }
            throw this.newTransformerException(Character.class, value);
        });
        answer.put(Double.class, value -> {
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            throw this.newTransformerException(Double.class, value);
        });
        answer.put(Float.class, value -> {
            if (value instanceof String) {
                return Float.valueOf((String)value);
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            throw this.newTransformerException(Float.TYPE, value);
        });
        answer.put(Integer.class, value -> {
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            throw this.newTransformerException(Integer.class, value);
        });
        answer.put(Long.class, value -> {
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            throw this.newTransformerException(Long.class, value);
        });
        answer.put(Short.class, value -> {
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            throw this.newTransformerException(Short.class, value);
        });
        answer.put(String.class, Object::toString);
    }

    protected void addPrimitiveArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(boolean[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveBoolArray((String)value);
            }
            if (value instanceof boolean[]) {
                return value;
            }
            if (value instanceof Boolean[]) {
                return EzyNumbersConverter.boolArrayWrapperToPrimitive((Boolean[])value);
            }
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToPrimitiveBoolArray((Collection)value);
            }
            throw this.newTransformerException(boolean[].class, value);
        });
        answer.put(byte[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveByteArray((String)value);
            }
            if (value instanceof byte[]) {
                return value;
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToPrimitiveBytes((Number[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToPrimitiveBytes((Collection)value);
            }
            throw this.newTransformerException(byte[].class, value);
        });
        answer.put(char[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveCharArray((String)value);
            }
            if (value instanceof char[]) {
                return value;
            }
            if (value instanceof Object[]) {
                return EzyNumbersConverter.numbersToPrimitiveChars((Object[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToPrimitiveChars((Collection)value);
            }
            throw this.newTransformerException(char[].class, value);
        });
        answer.put(double[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveDoubleArray((String)value);
            }
            if (value instanceof double[]) {
                return value;
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToPrimitiveDoubles((Number[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToPrimitiveDoubles((Collection)value);
            }
            throw this.newTransformerException(double[].class, value);
        });
        answer.put(float[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveFloatArray((String)value);
            }
            if (value instanceof float[]) {
                return value;
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToPrimitiveFloats((Number[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToPrimitiveFloats((Collection)value);
            }
            throw this.newTransformerException(float[].class, value);
        });
        answer.put(int[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveIntArray((String)value);
            }
            if (value instanceof int[]) {
                return value;
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToPrimitiveInts((Number[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToPrimitiveInts((Collection)value);
            }
            throw this.newTransformerException(int[].class, value);
        });
        answer.put(long[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveLongArray((String)value);
            }
            if (value instanceof long[]) {
                return value;
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToPrimitiveLongs((Number[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToPrimitiveLongs((Collection)value);
            }
            throw this.newTransformerException(long[].class, value);
        });
        answer.put(short[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveShortArray((String)value);
            }
            if (value instanceof short[]) {
                return value;
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToPrimitiveShorts((Number[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToPrimitiveShorts((Collection)value);
            }
            throw this.newTransformerException(short[].class, value);
        });
    }

    protected void addWrapperArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperBoolArray((String)value);
            }
            if (value instanceof Boolean[]) {
                return value;
            }
            if (value instanceof boolean[]) {
                return EzyNumbersConverter.boolArrayPrimitiveToWrapper((boolean[])value);
            }
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToWrapperBoolArray((Collection)value);
            }
            throw this.newTransformerException(Boolean[].class, value);
        });
        answer.put(Byte[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperByteArray((String)value);
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToWrapperBytes((Number[])value);
            }
            if (value instanceof byte[]) {
                return EzyNumbersConverter.byteArrayPrimitiveToWrapper((byte[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToWrapperBytes((Collection)value);
            }
            throw this.newTransformerException(Boolean[].class, value);
        });
        answer.put(Character[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperCharArray((String)value);
            }
            if (value instanceof Character[]) {
                return value;
            }
            if (value instanceof char[]) {
                return EzyNumbersConverter.charArrayPrimitiveToWrapper((char[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToWrapperChars((Collection)value);
            }
            throw this.newTransformerException(Character[].class, value);
        });
        answer.put(Double[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperDoubleArray((String)value);
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToWrapperDoubles((Number[])value);
            }
            if (value instanceof double[]) {
                return EzyNumbersConverter.doubleArrayPrimitiveToWrapper((double[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToWrapperDoubles((Collection)value);
            }
            throw this.newTransformerException(Double[].class, value);
        });
        answer.put(Float[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperFloatArray((String)value);
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToWrapperFloats((Number[])value);
            }
            if (value instanceof float[]) {
                return EzyNumbersConverter.floatArrayPrimitiveToWrapper((float[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToWrapperFloats((Collection)value);
            }
            throw this.newTransformerException(Float[].class, value);
        });
        answer.put(Integer[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperIntArray((String)value);
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToWrapperInts((Number[])value);
            }
            if (value instanceof int[]) {
                return EzyNumbersConverter.intArrayPrimitiveToWrapper((int[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToWrapperInts((Collection)value);
            }
            throw this.newTransformerException(Integer[].class, value);
        });
        answer.put(Long[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperLongArray((String)value);
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToWrapperLongs((Number[])value);
            }
            if (value instanceof long[]) {
                return EzyNumbersConverter.longArrayPrimitiveToWrapper((long[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToWrapperLongs((Collection)value);
            }
            throw this.newTransformerException(Long[].class, value);
        });
        answer.put(Short[].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperShortArray((String)value);
            }
            if (value instanceof Number[]) {
                return EzyNumbersConverter.numbersToWrapperShorts((Number[])value);
            }
            if (value instanceof short[]) {
                return EzyNumbersConverter.shortArrayPrimitiveToWrapper((short[])value);
            }
            if (value instanceof Collection) {
                return EzyNumbersConverter.numbersToWrapperShorts((Collection)value);
            }
            throw this.newTransformerException(Short[].class, value);
        });
        answer.put(String[].class, value -> {
            if (value instanceof String) {
                return ((String)value).split(",");
            }
            if (value instanceof String[]) {
                return value;
            }
            if (value instanceof Collection) {
                return EzyDataConverter.collectionToStringArray((Collection)value);
            }
            throw this.newTransformerException(String[].class, value);
        });
    }

    protected void addOtherTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Date.class, value -> {
            try {
                return EzyDates.parse(value);
            }
            catch (Exception e) {
                this.logger.info("value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(LocalDate.class, value -> {
            try {
                return EzyDates.parseDate(value, "yyyy-MM-dd");
            }
            catch (Exception e) {
                this.logger.info("value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(LocalDateTime.class, value -> {
            try {
                return EzyDates.parseDateTime(value);
            }
            catch (Exception e) {
                this.logger.info("value: {} is invalid", value, (Object)e);
                return null;
            }
        });
        answer.put(Class.class, value -> {
            try {
                return EzyClasses.getClass(value);
            }
            catch (Exception e) {
                this.logger.info("value: {} is invalid", value, (Object)e);
                return null;
            }
        });
    }

    protected void addTwoDimensionsPrimitiveArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(boolean[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveBoolArrays((String)value);
            }
            if (value instanceof boolean[][]) {
                return value;
            }
            if (value instanceof Boolean[][]) {
                return EzyNumbersConverter.boolArraysWrapperToPrimitive((Boolean[][])value);
            }
            throw this.newTransformerException(boolean[][].class, value);
        });
        answer.put(byte[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveByteArrays((String)value);
            }
            if (value instanceof byte[][]) {
                return value;
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToPrimitiveByteArrays((Number[][])value);
            }
            throw this.newTransformerException(byte[][].class, value);
        });
        answer.put(char[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveCharArrays((String)value);
            }
            if (value instanceof char[][]) {
                return value;
            }
            if (value instanceof Object[][]) {
                return EzyNumbersConverter.numbersToPrimitiveCharArrays((Object[][])value);
            }
            throw this.newTransformerException(char[][].class, value);
        });
        answer.put(double[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveDoubleArrays((String)value);
            }
            if (value instanceof double[][]) {
                return value;
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToPrimitiveDoubleArrays((Number[][])value);
            }
            throw this.newTransformerException(double[][].class, value);
        });
        answer.put(float[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveFloatArrays((String)value);
            }
            if (value instanceof float[][]) {
                return value;
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToPrimitiveFloatArrays((Number[][])value);
            }
            throw this.newTransformerException(float[][].class, value);
        });
        answer.put(int[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveIntArrays((String)value);
            }
            if (value instanceof int[][]) {
                return value;
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToPrimitiveIntArrays((Number[][])value);
            }
            throw this.newTransformerException(boolean[][].class, value);
        });
        answer.put(long[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveLongArrays((String)value);
            }
            if (value instanceof long[][]) {
                return value;
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToPrimitiveLongArrays((Number[][])value);
            }
            throw this.newTransformerException(long[][].class, value);
        });
        answer.put(short[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToPrimitiveShortArrays((String)value);
            }
            if (value instanceof short[][]) {
                return value;
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToPrimitiveShortArrays((Number[][])value);
            }
            throw this.newTransformerException(short[][].class, value);
        });
    }

    protected void addTwoDimensionsWrapperArrayTransformers(Map<Class, EzyToObject> answer) {
        answer.put(Boolean[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperBoolArrays((String)value);
            }
            if (value instanceof Boolean[][]) {
                return value;
            }
            if (value instanceof boolean[][]) {
                return EzyNumbersConverter.boolArraysPrimitiveToWrapper((boolean[][])value);
            }
            throw this.newTransformerException(Boolean[][].class, value);
        });
        answer.put(Byte[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperByteArrays((String)value);
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToWrapperByteArrays((Number[][])value);
            }
            if (value instanceof byte[][]) {
                return EzyNumbersConverter.byteArraysPrimitiveToWrapper((byte[][])value);
            }
            throw this.newTransformerException(Byte[][].class, value);
        });
        answer.put(Character[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperCharArrays((String)value);
            }
            if (value instanceof Object[][]) {
                return EzyNumbersConverter.numbersToWrapperCharArrays((Number[][])value);
            }
            if (value instanceof char[][]) {
                return EzyNumbersConverter.charArraysPrimitiveToWrapper((char[][])value);
            }
            throw this.newTransformerException(Character[][].class, value);
        });
        answer.put(Double[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperDoubleArrays((String)value);
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToWrapperDoubleArrays((Number[][])value);
            }
            if (value instanceof double[][]) {
                return EzyNumbersConverter.doubleArraysPrimitiveToWrapper((double[][])value);
            }
            throw this.newTransformerException(Double[][].class, value);
        });
        answer.put(Float[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperFloatArrays((String)value);
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToWrapperFloatArrays((Number[][])value);
            }
            if (value instanceof float[][]) {
                return EzyNumbersConverter.floatArraysPrimitiveToWrapper((float[][])value);
            }
            throw this.newTransformerException(Float[][].class, value);
        });
        answer.put(Integer[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperIntArrays((String)value);
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToWrapperIntArrays((Number[][])value);
            }
            if (value instanceof int[][]) {
                return EzyNumbersConverter.intArraysPrimitiveToWrapper((int[][])value);
            }
            throw this.newTransformerException(Integer[][].class, value);
        });
        answer.put(Long[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperLongArrays((String)value);
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToWrapperLongArrays((Number[][])value);
            }
            if (value instanceof long[][]) {
                return EzyNumbersConverter.longArraysPrimitiveToWrapper((long[][])value);
            }
            throw this.newTransformerException(Long[][].class, value);
        });
        answer.put(Short[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToWrapperShortArrays((String)value);
            }
            if (value instanceof Number[][]) {
                return EzyNumbersConverter.numbersToWrapperShortArrays((Number[][])value);
            }
            if (value instanceof short[][]) {
                return EzyNumbersConverter.shortArraysPrimitiveToWrapper((short[][])value);
            }
            throw this.newTransformerException(Short[][].class, value);
        });
        answer.put(String[][].class, value -> {
            if (value instanceof String) {
                return EzyStringConverter.stringToStringArrays((String)value);
            }
            if (value instanceof String[][]) {
                return value;
            }
            throw this.newTransformerException(String[][].class, value);
        });
    }

    private static final class EzySingletonValueConverter
    extends EzySimpleValueConverter {
        private static final EzySingletonValueConverter INSTANCE = new EzySingletonValueConverter();

        private EzySingletonValueConverter() {
        }

        public static EzySingletonValueConverter getInstance() {
            return INSTANCE;
        }
    }
}

