/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.collect.Lists;
import com.tvd12.ezyfox.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public final class EzyTypes {
    public static final Set<Class> BOOLEAN_TYPES = EzyTypes.booleanTypes();
    public static final Set<Class> PRIMITIVE_TYPES = EzyTypes.primitiveTypes();
    public static final Set<Class> WRAPPER_TYPES = EzyTypes.wrapperTypes();
    public static final Set<Class> ARRAY_PRIMITIVE_TYPES = EzyTypes.arrayPrimitiveTypes();
    public static final Set<Class> ARRAY_WRAPPER_TYPES = EzyTypes.arrayWrapperTypes();
    public static final Set<Class> TWO_DIMENSIONS_ARRAY_PRIMITIVE_TYPES = EzyTypes.twoDimensionsArrayPrimitiveTypes();
    public static final Set<Class> TWO_DIMENSIONS_ARRAY_WRAPPER_TYPES = EzyTypes.twoDimensionsArrayWrapperTypes();
    public static final Set<Class> STRING_TYPES = EzyTypes.stringTypes();
    public static final Set<Class> ALL_TYPES = EzyTypes.mergeAllTypes();
    public static final Set<Class> NON_ARRAY_TYPES = EzyTypes.nonArrayTypes();
    public static final Set<Class> COMMON_GENERIC_TYPES = EzyTypes.commonGenericTypes();
    public static final Map<Class, Class> PRIMITIVE_WRAPPER_TYPES_MAP = EzyTypes.mapPrimitiveAndWrapperTypes();

    private EzyTypes() {
    }

    private static Set<Class> booleanTypes() {
        Set<Class> set = Sets.newHashSet(Boolean.TYPE, Boolean.class);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> primitiveTypes() {
        Set<Class> set = Sets.newHashSet(Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> wrapperTypes() {
        Set<Class> set = Sets.newHashSet(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> arrayPrimitiveTypes() {
        Set<Class> set = Sets.newHashSet(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> arrayWrapperTypes() {
        Set<Class> set = Sets.newHashSet(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> twoDimensionsArrayPrimitiveTypes() {
        Set<Class> set = Sets.newHashSet(boolean[][].class, byte[][].class, char[][].class, double[][].class, float[][].class, int[][].class, long[][].class, short[][].class);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> twoDimensionsArrayWrapperTypes() {
        Set<Class> set = Sets.newHashSet(Boolean[][].class, Byte[][].class, Character[][].class, Double[][].class, Float[][].class, Integer[][].class, Long[][].class, Short[][].class);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> stringTypes() {
        Set<Class> set = Sets.newHashSet(String.class, String[].class, String[][].class);
        return Collections.unmodifiableSet(set);
    }

    private static Set<Class> mergeAllTypes() {
        HashSet<Class> merge = new HashSet<Class>();
        merge.addAll(Lists.newArrayList(PRIMITIVE_TYPES));
        merge.addAll(Lists.newArrayList(WRAPPER_TYPES));
        merge.addAll(Lists.newArrayList(ARRAY_PRIMITIVE_TYPES));
        merge.addAll(Lists.newArrayList(ARRAY_WRAPPER_TYPES));
        merge.addAll(Lists.newArrayList(TWO_DIMENSIONS_ARRAY_PRIMITIVE_TYPES));
        merge.addAll(Lists.newArrayList(TWO_DIMENSIONS_ARRAY_WRAPPER_TYPES));
        merge.addAll(Lists.newArrayList(STRING_TYPES));
        return Collections.unmodifiableSet(merge);
    }

    private static Set<Class> nonArrayTypes() {
        HashSet<Class<String>> merge = new HashSet<Class<String>>();
        merge.addAll(Lists.newArrayList(PRIMITIVE_TYPES));
        merge.addAll(Lists.newArrayList(WRAPPER_TYPES));
        merge.add(String.class);
        return Collections.unmodifiableSet(merge);
    }

    private static Map<Class, Class> mapPrimitiveAndWrapperTypes() {
        ConcurrentHashMap<Class<Comparable<Boolean>>, Class> map = new ConcurrentHashMap<Class<Comparable<Boolean>>, Class>();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        return Collections.unmodifiableMap(map);
    }

    private static Set<Class> commonGenericTypes() {
        Set<Class> set = Sets.newHashSet(Collection.class, List.class, ArrayList.class, CopyOnWriteArrayList.class, LinkedList.class, Set.class, HashSet.class, CopyOnWriteArraySet.class, Vector.class, Stack.class, Queue.class, Map.class, HashMap.class, TreeMap.class, ConcurrentHashMap.class);
        return Collections.unmodifiableSet(set);
    }
}

