/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import java.util.Collection;
import java.util.function.Function;

public final class EzySum {
    private EzySum() {
    }

    public static int sumBytes(byte[] numbers) {
        int total = 0;
        for (byte number : numbers) {
            total += number;
        }
        return total;
    }

    public static double sumDoubles(double[] numbers) {
        double total = 0.0;
        for (double number : numbers) {
            total += number;
        }
        return total;
    }

    public static float sumFloats(float[] numbers) {
        float total = 0.0f;
        for (float number : numbers) {
            total += number;
        }
        return total;
    }

    public static int sumInts(int[] numbers) {
        int total = 0;
        for (int number : numbers) {
            total += number;
        }
        return total;
    }

    public static long sumLongs(long[] numbers) {
        long total = 0L;
        for (long number : numbers) {
            total += number;
        }
        return total;
    }

    public static int sumShorts(short[] numbers) {
        int total = 0;
        for (short number : numbers) {
            total += number;
        }
        return total;
    }

    public static int sumBytes(Iterable<Byte> numbers) {
        int total = 0;
        for (Byte number : numbers) {
            total += number.byteValue();
        }
        return total;
    }

    public static double sumDoubles(Iterable<Double> numbers) {
        double total = 0.0;
        for (Double number : numbers) {
            total += number.doubleValue();
        }
        return total;
    }

    public static float sumFloats(Iterable<Float> numbers) {
        float total = 0.0f;
        for (Float number : numbers) {
            total += number.floatValue();
        }
        return total;
    }

    public static int sumInts(Iterable<Integer> numbers) {
        int total = 0;
        for (Integer number : numbers) {
            total += number.intValue();
        }
        return total;
    }

    public static long sumLongs(Iterable<Long> numbers) {
        long total = 0L;
        for (Long number : numbers) {
            total += number.longValue();
        }
        return total;
    }

    public static long sumToLongs(Collection<? extends Number> numbers) {
        long total = 0L;
        for (Number number : numbers) {
            total += number.longValue();
        }
        return total;
    }

    public static int sumShorts(Iterable<Short> numbers) {
        int total = 0;
        for (Short number : numbers) {
            total += number.shortValue();
        }
        return total;
    }

    public static <T> int sumToInt(T[] array, Function<T, Integer> func) {
        int total = 0;
        for (T t : array) {
            total += func.apply(t).intValue();
        }
        return total;
    }

    public static <T> int sumToInt(Iterable<T> iterable, Function<T, Integer> func) {
        int total = 0;
        for (T t : iterable) {
            total += func.apply(t).intValue();
        }
        return total;
    }

    public static <T> long sumToLong(T[] array, Function<T, Long> func) {
        long total = 0L;
        for (T t : array) {
            total += func.apply(t).longValue();
        }
        return total;
    }

    public static <T> long sumToLong(Iterable<T> iterable, Function<T, Long> func) {
        long total = 0L;
        for (T t : iterable) {
            total += func.apply(t).longValue();
        }
        return total;
    }
}

