/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Predicate;

public class EzyLinkedListSet<E>
extends LinkedList<E> {
    private static final long serialVersionUID = -6698639347522121319L;
    protected Set<E> elementSet = new HashSet();

    @Override
    public boolean add(E e) {
        boolean success = this.elementSet.add(e);
        if (success) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        boolean success = this.elementSet.add(element);
        if (success) {
            super.add(index, element);
        }
    }

    @Override
    public boolean remove(Object o) {
        super.remove(o);
        return this.elementSet.remove(o);
    }

    @Override
    public E remove() {
        Object e = super.remove();
        this.elementSet.remove(e);
        return e;
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        this.elementSet.remove(e);
        return e;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        super.removeAll(c);
        return this.elementSet.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList toRetain = new ArrayList();
        HashSet passed = new HashSet();
        for (Object e : c) {
            if (!this.elementSet.contains(e) || passed.contains(e)) continue;
            toRetain.add(e);
            passed.add(e);
        }
        super.retainAll(toRetain);
        return this.elementSet.retainAll(toRetain);
    }

    @Override
    public E removeFirst() {
        Object e = super.removeFirst();
        this.elementSet.remove(e);
        return e;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        boolean result = super.removeFirstOccurrence(o);
        this.elementSet.remove(o);
        return result;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        super.removeIf(filter);
        return this.elementSet.removeIf(filter);
    }

    @Override
    public E removeLast() {
        Object e = super.removeLast();
        this.elementSet.remove(e);
        return e;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        boolean answer = super.removeLastOccurrence(o);
        this.elementSet.remove(o);
        return answer;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int lastSize = this.elementSet.size();
        for (E e : c) {
            if (this.elementSet.contains(e)) continue;
            this.add(e);
        }
        int currentSize = this.elementSet.size();
        return lastSize != currentSize;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ArrayList<E> toAdd = new ArrayList<E>();
        for (E e : c) {
            if (this.elementSet.contains(e)) continue;
            this.elementSet.add(e);
            toAdd.add(e);
        }
        return super.addAll(index, toAdd);
    }

    @Override
    public void addFirst(E e) {
        boolean success = this.elementSet.add(e);
        if (success) {
            super.addFirst(e);
        }
    }

    @Override
    public void addLast(E e) {
        boolean success = this.elementSet.add(e);
        if (success) {
            super.addLast(e);
        }
    }

    @Override
    public boolean offer(E e) {
        boolean success = this.elementSet.add(e);
        if (success) {
            return super.add(e);
        }
        return false;
    }

    @Override
    public boolean offerFirst(E e) {
        boolean success = this.elementSet.add(e);
        if (success) {
            super.addFirst(e);
        }
        return success;
    }

    @Override
    public boolean offerLast(E e) {
        boolean success = this.elementSet.add(e);
        if (success) {
            super.addLast(e);
        }
        return success;
    }

    @Override
    public E poll() {
        Object e = super.poll();
        if (e != null) {
            this.elementSet.remove(e);
        }
        return e;
    }

    @Override
    public E pollFirst() {
        Object e = super.pollFirst();
        if (e != null) {
            this.elementSet.remove(e);
        }
        return e;
    }

    @Override
    public E pollLast() {
        Object e = super.pollLast();
        if (e != null) {
            this.elementSet.remove(e);
        }
        return e;
    }

    @Override
    public boolean contains(Object o) {
        return this.elementSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elementSet.containsAll(c);
    }
}

