/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.reader;

import com.tvd12.properties.file.util.FileUtil;
import com.tvd12.properties.file.util.InputStreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public interface FileReader {
    default public Properties read(Class<?> context, String filePath) {
        return this.read(context.getClassLoader(), filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Properties read(ClassLoader classLoader, String filePath) {
        try (InputStream inputStream = InputStreamUtil.getInputStream(classLoader, filePath);){
            Properties properties = this.loadInputStreamOrThrows(inputStream, FileUtil.getFileExtension(filePath));
            return properties;
        }
        catch (IOException e) {
            return new Properties();
        }
    }

    default public List<Properties> read(Class<?> context, String ... filePaths) {
        return this.read(context.getClassLoader(), filePaths);
    }

    default public List<Properties> read(ClassLoader classLoader, String ... filePaths) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        for (String file : filePaths) {
            result.add(this.read(classLoader, file));
        }
        return result;
    }

    default public List<Properties> read(Class<?> context, Collection<String> filePaths) {
        return this.read(context.getClassLoader(), filePaths);
    }

    default public List<Properties> read(ClassLoader classLoader, Collection<String> filePaths) {
        return this.read(classLoader, filePaths.toArray(new String[0]));
    }

    default public Properties read(String filePath) {
        return this.read(InputStreamUtil.getDefaultClassLoader(), filePath);
    }

    default public Properties read(File file) {
        Properties properties = null;
        try (InputStream inputStream = InputStreamUtil.getInputStreamByAbsolutePath(file);){
            if (inputStream != null) {
                properties = this.loadInputStreamOrThrows(inputStream, FileUtil.getFileExtension(file.getPath()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties != null ? properties : new Properties();
    }

    default public List<Properties> read(String ... filePaths) {
        return this.read(InputStreamUtil.getDefaultClassLoader(), filePaths);
    }

    default public List<Properties> read(File ... files) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        for (File file : files) {
            result.add(this.read(file));
        }
        return result;
    }

    default public List<Properties> read(Collection<File> files) {
        return this.read(files.toArray(new File[0]));
    }

    default public Properties loadInputStream(InputStream inputStream) {
        return this.loadInputStream(inputStream, null);
    }

    public Properties loadInputStream(InputStream var1, String var2);

    default public Properties loadInputStreamOrThrows(InputStream inputStream, String contentType) throws IOException {
        return this.loadInputStream(inputStream, contentType);
    }

    default public List<Properties> loadInputStreams(InputStream ... inputStreams) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        for (InputStream inputStream : inputStreams) {
            result.add(this.loadInputStream(inputStream));
        }
        return result;
    }

    default public List<Properties> loadInputStreams(Collection<InputStream> inputStreams) {
        return this.loadInputStreams(inputStreams.toArray(new InputStream[0]));
    }
}

