/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import com.tvd12.ezyfox.io.EzyStrings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.Arguments;
import org.youngmonkeys.ezyplatform.sdk.tools.data.BuildTool;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.CommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.io.MavenProjectDependenciesLinker;
import org.youngmonkeys.ezyplatform.sdk.tools.io.MavenProjectDependenciesWriter;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ProjectDependenciesLinker;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ProjectDependenciesWriter;

public abstract class AbstractCommandHandler<A extends Arguments>
implements CommandHandler<A> {
    protected final void println(String message) {
        System.out.println(message);
    }

    protected final String getTargetModulesFolder(BuildTool buildTool, String projectName) {
        Path answer = buildTool == BuildTool.MAVEN ? Paths.get("target", new String[0]) : Paths.get("build", new String[0]);
        return answer.resolve("project").resolve(projectName).toString();
    }

    protected final List<String> getModules(String projectFolder) {
        if (EzyStrings.isNotBlank((String)projectFolder)) {
            return Collections.singletonList(projectFolder);
        }
        File modulePropertiesFile = new File("module.properties");
        if (modulePropertiesFile.exists()) {
            return Collections.singletonList(modulePropertiesFile.getParent());
        }
        File currentFolder = new File(".");
        File[] fileList = currentFolder.listFiles();
        ArrayList<String> answer = new ArrayList<String>();
        if (fileList != null) {
            for (File child : fileList) {
                Path modulePropertiesPath = Paths.get(child.getName(), "module.properties");
                if (!Files.exists(modulePropertiesPath, new LinkOption[0])) continue;
                answer.add(child.getName());
            }
        }
        return answer;
    }

    protected final Set<String> extractMultiValuesArg(String arg) {
        return Arrays.stream(arg.split(",")).map(String::trim).collect(Collectors.toSet());
    }

    protected final Set<ModuleType> extractModuleType(String arg) {
        String[] strs = arg.split(",");
        HashSet<ModuleType> answer = new HashSet<ModuleType>();
        for (String str : strs) {
            String strTrim = str.trim();
            if (strTrim.equals("all")) {
                answer.addAll(Arrays.asList(ModuleType.values()));
                break;
            }
            ModuleType moduleType = ModuleType.of(str);
            if (moduleType == null) {
                throw new IllegalArgumentException("invalid module type: " + str + ", run help to see how to create a project");
            }
            answer.add(moduleType);
        }
        return answer;
    }

    protected final ProjectDependenciesWriter newProjectDependenciesWriter() {
        return new MavenProjectDependenciesWriter();
    }

    protected final ProjectDependenciesLinker newProjectDependenciesLinker() {
        return new MavenProjectDependenciesLinker();
    }
}

