/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.Arguments;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.RemoveLowerVersionLibsArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.data.Lib;
import org.youngmonkeys.ezyplatform.sdk.tools.extractor.LibExtractor;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;

public class RemoveLowerVersionLibsCommandHandler
extends AbstractCommandHandler<RemoveLowerVersionLibsArguments> {
    @Override
    public String handle(RemoveLowerVersionLibsArguments args) {
        File folder = new File(args.getTargetFolder());
        File[] files = folder.listFiles();
        if (files == null) {
            return "Empty folder";
        }
        List libNames = Arrays.stream(files).map(File::getName).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        List libs = libNames.stream().map(LibExtractor::extractLib).collect(Collectors.toList());
        HashMap<String, String> versionByName = new HashMap<String, String>();
        ArrayList<Lib> lowerVersionLibs = new ArrayList<Lib>();
        for (Lib lib : libs) {
            if (versionByName.containsKey(lib.getName())) {
                lowerVersionLibs.add(lib);
                continue;
            }
            versionByName.put(lib.getName(), lib.getVersion());
        }
        for (Lib lowerVersionLib : lowerVersionLibs) {
            File lib = Paths.get(folder.toString(), lowerVersionLib.getFullName()).toFile();
            if (!lib.delete()) continue;
            System.out.println("Removed: " + lib);
        }
        return "Done";
    }

    @Override
    public Arguments parse(String[] args) {
        return new RemoveLowerVersionLibsArguments(args.length > 0 ? args[0] : "");
    }
}

