/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteArray
implements Serializable {
    private static final long serialVersionUID = 7607209931402134720L;
    protected final byte[] bytes;

    public ByteArray(String bytes) {
        this(bytes.getBytes());
    }

    public ByteArray(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes can not be null");
        }
        this.bytes = bytes;
    }

    public static ByteArray wrap(String bytes) {
        return new ByteArray(bytes);
    }

    public static ByteArray wrap(byte[] bytes) {
        return new ByteArray(bytes);
    }

    public static List<ByteArray> wrap(byte[][] byteArrays) {
        ArrayList<ByteArray> list = new ArrayList<ByteArray>(byteArrays.length);
        for (byte[] bytes : byteArrays) {
            list.add(ByteArray.wrap(bytes));
        }
        return list;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        ByteArray t = (ByteArray)other;
        return Arrays.equals(this.bytes, t.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return new String(this.bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

