/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFileExtension(String filePath) {
        int lastDotIndex = filePath.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        if (lastDotIndex >= filePath.length() - 1) {
            return null;
        }
        return filePath.substring(lastDotIndex + 1);
    }

    public static String getFileClasspathByProfile(String filePathString, String profile) {
        return FileUtil.getFilePathByProfile(filePathString, profile).replace('\\', '/');
    }

    public static File getFileSytemByProfile(File file, String profile) {
        return new File(FileUtil.getFilePathByProfile(file.toString(), profile));
    }

    public static String getFilePathByProfile(String filePathString, String profile) {
        Path filePath = Paths.get(filePathString, new String[0]);
        String fileName = filePath.getFileName().toString();
        String fileExtension = null;
        String actualFileName = fileName;
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            fileExtension = fileName.substring(lastDotIndex + 1);
            actualFileName = lastDotIndex > 0 ? fileName.substring(0, lastDotIndex) : null;
        }
        String newActualFileName = actualFileName == null ? profile : actualFileName + "-" + profile;
        String newFileName = fileExtension == null ? newActualFileName : newActualFileName + "." + fileExtension;
        Path folderPath = filePath.getParent();
        return folderPath == null ? newFileName : Paths.get(folderPath.toString(), newFileName).toString();
    }
}

