/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.writer;

import com.tvd12.properties.file.exception.PropertiesFileException;
import com.tvd12.properties.file.writer.FileWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class BaseFileWriter
implements FileWriter {
    @Override
    public ByteArrayOutputStream write(Properties properties) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            properties.store(out, "written by com.tvd12:properties-file");
        }
        catch (IOException e) {
            throw new PropertiesFileException("Can not write properties to output stream", e);
        }
        return out;
    }

    @Override
    public void write(Properties properties, String filePath) {
        this.write(properties, new File(filePath));
    }

    @Override
    public void write(Properties properties, File file) {
        try (ByteArrayOutputStream out = this.write(properties);){
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] bytes = this.encode(out);
            this.writeBytes0(file, bytes);
        }
        catch (IOException e) {
            throw new PropertiesFileException("Can not write properties to file", e);
        }
    }

    protected void writeBytes0(File file, byte[] bytes) throws IOException {
        try (FileOutputStream fos = this.newFileOutputStream(file);){
            fos.write(bytes);
        }
    }

    protected FileOutputStream newFileOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    protected byte[] encode(ByteArrayOutputStream out) {
        return out.toByteArray();
    }
}

