/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.constant;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;

public final class SdkConstants {
    public static final String EXTENSION_PNG = ".png";
    public static final String MODULE_TYPE_COMMON = "common";
    public static final String FILE_POM_XML = "pom.xml";
    public static final String FILE_EXPORT_SH = "export.sh";
    public static final String FILE_EXPORT_BAT = "export.bat";
    public static final String FILE_DEPENDENCIES_XML = "dependencies.xml";
    public static final String FILE_DS_STORE = ".DS_Store";
    public static final String FILE_MODULE_PROPERTIES = "module.properties";
    public static final String FILE_LOCAL_PROPERTIES = "local.properties";
    public static final String FILE_SWAGGER_YAML = "swagger.yaml";
    public static final String FOLDER_API_DOCS = "apidocs";
    public static final String FOLDER_BUILD = "build";
    public static final String FOLDER_LIB = "lib";
    public static final String FOLDER_RESOURCES = "resources";
    public static final String FOLDER_PROJECT = "project";
    public static final String FOLDER_TARGET = "target";
    public static final String FOLDER_TEMPLATES = "templates";
    public static final String FOLDER_PROJECT_TEMPLATE = "project-template";
    public static final String PATH_RESOURCES = "src/main/resources";
    public static final String PATTERN_PACKAGE_NAME = "[a-z0-9_.]+";
    public static final String PATTERN_PROJECT_NAME = "[a-zA-Z0-9\\-\\s]{2,60}";
    public static final String PATTERN_VERSION = "[0-9]+[.][0-9]+[.][0-9]+";
    public static final String PROPERTY_NAME_TYPE = "type";
    public static final String PROPERTY_NAME_EZYPLATFORM_SDK = "EZYPLATFORM_SDK";
    public static final String PROPERTY_NAME_EZYPLATFORM_HOME = "EZYPLATFORM_HOME";
    public static final String SCOPE_SYSTEM = "system";
    public static final String SCOPE_PROVIDED = "provided";
    public static final String TAG_NAME_ARTIFACT_ID = "artifactId";
    public static final String TAG_NAME_BUILD = "build";
    public static final String TAG_NAME_COMMON = "common";
    public static final String TAG_NAME_DEPENDENCIES = "dependencies";
    public static final String TAG_NAME_DEPENDENCY = "dependency";
    public static final String TAG_NAME_DEPENDENCY_MANAGEMENT = "dependencyManagement";
    public static final String TAG_NAME_DIRECTORY = "directory";
    public static final String TAG_NAME_GROUP_ID = "groupId";
    public static final String TAG_NAME_PARENT = "parent";
    public static final String TAG_NAME_PLUGIN_REPOSITORIES = "pluginRepositories";
    public static final String TAG_NAME_PROFILE = "profile";
    public static final String TAG_NAME_PROFILES = "profiles";
    public static final String TAG_NAME_PROPERTIES = "properties";
    public static final String TAG_NAME_REPOSITORIES = "repositories";
    public static final String TAG_NAME_RESOURCE = "resource";
    public static final String TAG_NAME_RESOURCES = "resources";
    public static final String TAG_NAME_SCOPE = "scope";
    public static final String TAG_NAME_SYSTEM_PATH = "systemPath";
    public static final String TAG_NAME_VERSION = "version";
    public static final String PROJECT_NAME_PATTERN = "^[a-zA-Z0-9_.#\\s]{3,64}$";
    public static final List<String> BUILD_FOLDER_NAMES = Collections.unmodifiableList(Arrays.asList("target", "build"));
    public static final Map<ModuleType, String> MODULE_SUB_PACKAGES = Collections.unmodifiableMap(EzyMapBuilder.mapBuilder().put((Object)ModuleType.ADMIN_PLUGIN, (Object)"admin").put((Object)ModuleType.SOCKET_APP, (Object)"socket.app").put((Object)ModuleType.SOCKET_PLUGIN, (Object)"socket.plugin").put((Object)ModuleType.WEB_PLUGIN, (Object)"web").put((Object)ModuleType.THEME, (Object)"web").toMap());
    public static final Set<String> PARENT_TAGS_IN_POM_FILE = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{SdkConstants.wrapOpenXmlTagName("parent"), SdkConstants.wrapOpenXmlTagName("repositories"), SdkConstants.wrapOpenXmlTagName("pluginRepositories"), SdkConstants.wrapOpenXmlTagName("properties"), SdkConstants.wrapOpenXmlTagName("dependencyManagement"), SdkConstants.wrapOpenXmlTagName("dependencies"), SdkConstants.wrapOpenXmlTagName("build"), SdkConstants.wrapOpenXmlTagName("profiles")}));

    public static String wrapOpenXmlTagName(String xmlTagName) {
        return '<' + xmlTagName + '>';
    }

    public static String wrapCloseXmlTagName(String xmlTagName) {
        return "</" + xmlTagName + '>';
    }
}

