/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyReturner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PomXmlReaders;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ProjectDependenciesWriter;
import org.youngmonkeys.ezyplatform.sdk.tools.io.XmlReader;

public class MavenProjectDependenciesWriter
implements ProjectDependenciesWriter {
    @Override
    public void write(String projectName, String targetFolder) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document outputDocument = builder.newDocument();
        File projectFolder = new File(".");
        Map<String, Map<String, String>> pomFileMap = FileProxy.getPomFiles(projectFolder.toString());
        Map pomDocumentMap = EzyMaps.newHashMapNewValues(pomFileMap, pomFiles -> EzyMaps.newHashMapNewValues((Map)pomFiles, pomFile -> (Document)EzyReturner.returnWithException(() -> builder.parse((String)pomFile))));
        Element dependenciesElement = outputDocument.createElement("dependencies");
        List<Document> pomDocuments = pomDocumentMap.values().stream().flatMap(it -> it.values().stream()).collect(Collectors.toList());
        String projectVersionPropertyName = EzyStrings.toDotCase((String)projectName) + ".version";
        String projectVersion = PomXmlReaders.getProjectVersionFromPomOrThrow(projectFolder, builder);
        this.appendPropertyNodes(pomDocuments, projectVersionPropertyName, projectVersion, outputDocument, dependenciesElement);
        String projectGroupId = PomXmlReaders.getProjectGroupIdOrThrow(projectFolder, builder);
        this.appendDependencyElements(projectFolder, pomDocumentMap, projectName, projectVersionPropertyName, projectGroupId, outputDocument, dependenciesElement);
        outputDocument.appendChild(dependenciesElement);
        String outputFile = Paths.get(targetFolder, "dependencies.xml").toString();
        XmlReader.writeToFile(outputDocument, outputFile, content -> content.replace("${project.version}", "${" + projectVersionPropertyName + "}"));
    }

    private void appendDependencyElements(File projectFolder, Map<String, Map<String, Document>> pomDocuments, String projectName, String projectVersionPropertyName, String projectGroupId, Document outputDocument, Element dependenciesElement) {
        for (String moduleType : pomDocuments.keySet()) {
            Map<String, Document> pomDocumentByFolder = pomDocuments.get(moduleType);
            List<Element> dependencyElements = this.extractDependencyElements(pomDocumentByFolder.values());
            if (dependencyElements.isEmpty()) continue;
            Element groupElement = outputDocument.createElement(moduleType);
            for (Element dependencyElement : dependencyElements) {
                String scope;
                Element element = (Element)outputDocument.importNode(dependencyElement, true);
                String artifactId = XmlReader.getElementTextContent(element, "artifactId");
                Path moduleFolderPath = Paths.get(projectFolder.toString(), artifactId);
                ModuleType moduleTypeEnum = ModuleType.of(moduleType);
                if (Files.exists(moduleFolderPath, new LinkOption[0]) && moduleTypeEnum != null) {
                    Element scopeElement = outputDocument.createElement("scope");
                    scopeElement.setTextContent("system");
                    element.appendChild(scopeElement);
                    Element systemPathElement = outputDocument.createElement("systemPath");
                    systemPathElement.setTextContent("${ezyplatform.home}/" + moduleTypeEnum.getParentFolder() + "/" + moduleTypeEnum.getContainerFolder() + "/" + projectName + "/lib/" + artifactId + "-${" + projectVersionPropertyName + "}.jar");
                    element.appendChild(systemPathElement);
                }
                if ((scope = XmlReader.getElementTextContent(element, "scope")) == null) {
                    Element scopeElement = outputDocument.createElement("scope");
                    scopeElement.setTextContent("provided");
                    element.appendChild(scopeElement);
                }
                groupElement.appendChild(element);
            }
            ModuleType moduleTypeEnum = ModuleType.of(moduleType);
            if (moduleTypeEnum != null && moduleTypeEnum != ModuleType.THEME) {
                for (String folder : pomDocumentByFolder.keySet()) {
                    groupElement.appendChild(this.createModuleDependencyElement(projectName, projectVersionPropertyName, projectGroupId, moduleTypeEnum, folder, outputDocument));
                }
            }
            dependenciesElement.appendChild(groupElement);
        }
    }

    private Element createModuleDependencyElement(String projectName, String projectVersionPropertyName, String projectGroupId, ModuleType moduleType, String folder, Document outputDocument) {
        Element element = outputDocument.createElement("dependency");
        Element groupIdElement = outputDocument.createElement("groupId");
        groupIdElement.setTextContent(projectGroupId);
        element.appendChild(groupIdElement);
        Element artifactIdElement = outputDocument.createElement("artifactId");
        artifactIdElement.setTextContent(folder);
        element.appendChild(artifactIdElement);
        Element versionElement = outputDocument.createElement("version");
        versionElement.setTextContent("${" + projectVersionPropertyName + "}");
        element.appendChild(versionElement);
        Element scopeElement = outputDocument.createElement("scope");
        scopeElement.setTextContent("system");
        element.appendChild(scopeElement);
        Element systemPathElement = outputDocument.createElement("systemPath");
        systemPathElement.setTextContent("${ezyplatform.home}/" + moduleType.getParentFolder() + "/" + moduleType.getContainerFolder() + "/" + projectName + "/lib/" + folder + "-${" + projectVersionPropertyName + "}.jar");
        element.appendChild(systemPathElement);
        return element;
    }

    private void appendPropertyNodes(List<Document> pomDocuments, String projectVersionPropertyName, String projectVersion, Document outputDocument, Element dependenciesElement) {
        List<Node> propertyNodes = this.extractPropertyNodes(pomDocuments);
        if (propertyNodes.isEmpty()) {
            return;
        }
        Element propertiesElement = outputDocument.createElement("properties");
        for (Node propertyNode : propertyNodes) {
            Node node = outputDocument.importNode(propertyNode, true);
            propertiesElement.appendChild(node);
        }
        Element projectVersionElement = outputDocument.createElement(projectVersionPropertyName);
        projectVersionElement.setTextContent(projectVersion);
        propertiesElement.appendChild(projectVersionElement);
        dependenciesElement.appendChild(propertiesElement);
    }

    private List<Element> extractDependencyElements(Collection<Document> pomDocuments) {
        TreeMap<String, Element> elementMap = new TreeMap<String, Element>();
        for (Document pomDocument : pomDocuments) {
            List<Element> elements = this.extractDependencyElements(pomDocument);
            for (Element element : elements) {
                String groupId = XmlReader.getElementTextContent(element, "groupId");
                String artifactId = XmlReader.getElementTextContent(element, "artifactId");
                String key = groupId + ":" + artifactId;
                elementMap.putIfAbsent(key, element);
            }
        }
        return new ArrayList<Element>(elementMap.values());
    }

    private List<Element> extractDependencyElements(Document pomDocument) {
        ArrayList<Element> answer = new ArrayList<Element>();
        List<Element> dependencyElements = XmlReader.getChildrenOfElement(pomDocument, "dependencies", "dependency");
        for (Element element : dependencyElements) {
            String version;
            String artifactId;
            String groupId = XmlReader.getElementTextContent(element, "groupId");
            if (groupId == null || (artifactId = XmlReader.getElementTextContent(element, "artifactId")) == null || (version = XmlReader.getElementTextContent(element, "version")) == null) continue;
            answer.add(element);
        }
        return answer;
    }

    private List<Node> extractPropertyNodes(List<Document> pomDocuments) {
        HashMap<String, Node> elementMap = new HashMap<String, Node>();
        for (Document pomDocument : pomDocuments) {
            List<Node> nodes = XmlReader.getChildrenOfElement(pomDocument, "properties");
            for (Node node : nodes) {
                elementMap.putIfAbsent(node.getNodeName(), node);
            }
        }
        return elementMap.values().stream().sorted(Comparator.comparing(Node::getNodeName)).collect(Collectors.toList());
    }
}

