/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.Arguments;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.EmptyArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileProxy;

public class AddLicenseCommandHandler
extends AbstractCommandHandler<Arguments> {
    private static final String[] INCLUSIVE_FILE_EXTENSIONS = new String[]{".java", ".kt", ".js", ".xml", ".html", ".css", ".scss", ".properties", ".sh", ".sql"};
    private final List<String> licenseLines = this.readLicense();
    private final Set<String> ignoreLicenseFilePatterns = new HashSet<String>();
    private final Map<String, List<String>> licenseByFileExtension = new HashMap<String, List<String>>();
    private static final String FILE_IGNORE_LICENSE = ".ignore_license";

    public AddLicenseCommandHandler() {
        this.licenseByFileExtension.put(".java", this.toSpecificLicense("/*", "*", "*/"));
        this.licenseByFileExtension.put(".kt", this.toSpecificLicense("/*", "*", "*/"));
        this.licenseByFileExtension.put(".js", this.toSpecificLicense("/*!", "*", "*/"));
        this.licenseByFileExtension.put(".xml", this.toSpecificLicense("<!--", "~", "-->"));
        this.licenseByFileExtension.put(".html", this.toSpecificLicense("<!--", "~", "-->"));
        this.licenseByFileExtension.put(".css", this.toSpecificLicense("/*!", "*", "*/"));
        this.licenseByFileExtension.put(".scss", this.toSpecificLicense("/*", "*", "*/"));
        this.licenseByFileExtension.put(".properties", this.toSpecificLicense("#", "#", "#"));
        this.licenseByFileExtension.put(".sh", this.toSpecificLicense("#", "#", "#"));
        this.licenseByFileExtension.put(".sql", this.toSpecificLicense("/*", "*", "*/"));
    }

    private List<String> readLicense() {
        List<String> lines = FileProxy.readLines("licenses/ezyplatform-1.0.0.txt");
        LocalDateTime now = LocalDateTime.now();
        String year = String.valueOf(now.getYear());
        String firstLine = lines.get(0).replace("${year}", year);
        lines.set(0, firstLine);
        return lines;
    }

    @Override
    public String handle(Arguments args) {
        File root = new File(".");
        if (!this.isValidLocation(root.toPath())) {
            throw new IllegalStateException("We can only add the license to an java or kotlin project. That project must contains pom.xml or build.gradle or build.gralde.kts");
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (queue.size() > 0) {
            File folder = (File)queue.poll();
            Path path = folder.toPath();
            this.readIgnoreFilePatterns(path);
            File[] files = folder.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!this.isValidFilePattern(file)) continue;
                if (file.isDirectory()) {
                    queue.add(file);
                    continue;
                }
                if (!this.isValidFile(file)) continue;
                this.addLicense(file.toPath());
            }
        }
        return "Add license done!!!";
    }

    private void readIgnoreFilePatterns(Path folder) {
        File ignoreFile = folder.resolve(FILE_IGNORE_LICENSE).toFile();
        if (ignoreFile.exists()) {
            List<String> lines = FileProxy.readContentLines(ignoreFile.toString());
            for (String filePattern : lines) {
                this.ignoreLicenseFilePatterns.add(folder.resolve(filePattern).toString());
            }
        }
    }

    private void addLicense(Path file) {
        String pathString = file.toString();
        for (String ext : INCLUSIVE_FILE_EXTENSIONS) {
            if (!pathString.endsWith(ext)) continue;
            this.addLicense(file, ext);
            break;
        }
        System.out.println("added to: " + file);
    }

    private void addLicense(Path file, String fileExtension) {
        String readLine;
        int i;
        List<String> readLines;
        try {
            readLines = Files.readAllLines(file);
        }
        catch (Exception e) {
            this.println("can not read file: " + file + ", error: " + e.getClass().getName() + " (" + e.getMessage() + ")");
            return;
        }
        int firstIndex = -1;
        if (fileExtension.equals(".xml")) {
            for (i = 0; i < readLines.size(); ++i) {
                readLine = readLines.get(i);
                if (!readLine.contains("<?xml")) continue;
                firstIndex = i;
                break;
            }
        } else if (fileExtension.equals(".sh")) {
            for (i = 0; i < readLines.size(); ++i) {
                readLine = readLines.get(i);
                if (!readLine.contains("#!/bin/sh")) continue;
                firstIndex = i;
                break;
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        List<String> license = this.licenseByFileExtension.get(fileExtension);
        if (firstIndex >= 0) {
            lines.add(readLines.get(0));
            lines.addAll(license);
            if (readLines.size() > 1) {
                lines.addAll(readLines.subList(1, readLines.size()));
            }
        } else {
            lines.addAll(license);
            lines.add("");
            lines.addAll(readLines);
        }
        try {
            Files.write(file, lines, new OpenOption[0]);
        }
        catch (IOException e) {
            this.println("can not write to file: " + file + ", error: " + e.getClass().getName() + " (" + e.getMessage() + ")");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidFile(File path) {
        if (path.isDirectory()) return false;
        if (path.isHidden()) {
            return false;
        }
        boolean validFileExtension = false;
        String pathString = path.toString();
        for (String extension : INCLUSIVE_FILE_EXTENSIONS) {
            if (!pathString.endsWith(extension)) continue;
            validFileExtension = true;
            break;
        }
        if (!validFileExtension) {
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return true;
            } while (!line.contains("Copyright") || !line.contains("youngmonkeys.org"));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.println("can not read file: " + path + ", error: " + e.getClass().getName() + " (" + e.getMessage() + ")");
        }
        return true;
    }

    private boolean isValidFilePattern(File path) {
        String pathString = path.toString();
        for (String pattern : this.ignoreLicenseFilePatterns) {
            if (!AddLicenseCommandHandler.matchPattern(pathString, pattern)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidLocation(Path root) {
        return Files.exists(root.resolve("pom.xml"), new LinkOption[0]) || Files.exists(root.resolve("build.gradle"), new LinkOption[0]) || Files.exists(root.resolve("build.gradle.kts"), new LinkOption[0]);
    }

    @Override
    public Arguments parse(String[] args) {
        return EmptyArguments.getInstance();
    }

    private List<String> toSpecificLicense(String firstTag, String lineTag, String endTag) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(firstTag);
        for (String line : this.licenseLines) {
            lines.add(" " + lineTag + " " + line);
        }
        lines.add(endTag);
        return lines;
    }

    private static boolean matchPattern(String path, String pattern) {
        if (pattern.contains("*")) {
            String regex = pattern.replace("**", "([\\w\\d_\\-\\.\\/\\$\\@]+)").replace("*", "([\\w\\d_\\-\\.\\$\\@]+)");
            return path.matches(regex);
        }
        return path.startsWith(pattern);
    }
}

