/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import com.tvd12.ezyfox.util.EzyDirectories;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.Arguments;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.ExportArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.constant.SdkConstants;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleProperties;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.extractor.LibExtractor;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileNameProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.LocalPropertiesReader;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ModulePropertiesReader;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFileProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFolderProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.SystemDependenciesFetcher;

public class ExportCommandHandler
extends AbstractCommandHandler<ExportArguments> {
    private static final String FOLDER_RESOURCES = "resources";
    private static final String PATH_RESOURCES = "src/main/resources";
    private static final String FILE_MODULE_PROPERTIES = "module.properties";
    private static final String FOLDER_LIB = "lib";

    @Override
    public Arguments parse(String[] args) {
        if (args.length == 0) {
            return new ExportArguments(null);
        }
        return new ExportArguments(args[0].trim());
    }

    @Override
    public String handle(ExportArguments args) throws Exception {
        List<String> modules = this.getModules(args);
        if (modules.isEmpty()) {
            return "there is no module to export";
        }
        boolean firstLoopRound = true;
        Map<String, ModuleProperties> modulePropertiesMap = this.readModuleProperties(modules);
        LocalPropertiesReader localPropertiesReader = new LocalPropertiesReader();
        Map<String, Set<String>> systemDependenciesMapToModule = new SystemDependenciesFetcher().getSystemDependenciesMapToModule(new File(".").toString());
        for (String module : modulePropertiesMap.keySet()) {
            ModuleProperties moduleProperties = modulePropertiesMap.get(module);
            String ezyplatformHome = localPropertiesReader.getEzyPlatformHome(module);
            if (firstLoopRound) {
                firstLoopRound = false;
                this.exportDependenciesXmlFile(ezyplatformHome, moduleProperties.getTargetModuleName());
            }
            Set<String> systemDependencies = systemDependenciesMapToModule.getOrDefault(module, Collections.emptySet());
            this.exportModule(module, moduleProperties, ezyplatformHome, systemDependencies);
        }
        return "";
    }

    private List<String> getModules(ExportArguments args) {
        return this.getModules(args.getModule());
    }

    private Map<String, ModuleProperties> readModuleProperties(List<String> modules) {
        ModulePropertiesReader reader = new ModulePropertiesReader();
        HashMap<String, ModuleProperties> modulePropertiesMap = new HashMap<String, ModuleProperties>();
        for (String module : modules) {
            modulePropertiesMap.put(module, reader.read(module));
        }
        TreeMap<String, ModuleProperties> answer = new TreeMap<String, ModuleProperties>(Comparator.comparing(a -> ((ModuleProperties)modulePropertiesMap.get(a)).getTypeEnum()));
        answer.putAll(modulePropertiesMap);
        return answer;
    }

    private void exportModule(String module, ModuleProperties moduleProperties, String ezyplatformHome, Set<String> systemDependencies) throws Exception {
        String targetFolder = moduleProperties.getTargetFolder();
        String targetModuleName = moduleProperties.getTargetModuleName();
        String zoneSettingFile = moduleProperties.getZoneSettingFile();
        String descriptionFile = moduleProperties.getDescriptionFile();
        String settingsFile = moduleProperties.getSettingsFile();
        String menusFile = moduleProperties.getMenusFile();
        String version = moduleProperties.getVersion();
        this.exportModuleProperties(module, ezyplatformHome, targetFolder, targetModuleName);
        this.exportFile(module, ezyplatformHome, targetFolder, targetModuleName, zoneSettingFile);
        this.exportFile(module, ezyplatformHome, targetFolder, targetModuleName, descriptionFile);
        this.exportFile(module, ezyplatformHome, targetFolder, targetModuleName, settingsFile);
        this.exportFile(module, ezyplatformHome, targetFolder, targetModuleName, menusFile);
        this.exportFile(module, ezyplatformHome, targetFolder, targetModuleName, "swagger.yaml");
        this.exportResources(module, ezyplatformHome, targetFolder, targetModuleName);
        this.exportLibs(module, ezyplatformHome, targetFolder, targetModuleName, version);
        this.exportSystemDependencies(ezyplatformHome, targetFolder, targetModuleName, systemDependencies);
        this.println("export successfully " + targetModuleName + " to " + Paths.get(ezyplatformHome, targetFolder));
    }

    private void exportModuleProperties(String module, String ezyplatformHome, String targetFolder, String targetModuleName) {
        Path modulePropertiesFile = module != null ? Paths.get(module, FILE_MODULE_PROPERTIES) : Paths.get(FILE_MODULE_PROPERTIES, new String[0]);
        Path target = Paths.get(ezyplatformHome, targetFolder, targetModuleName, FILE_MODULE_PROPERTIES);
        new PathFileProxy(modulePropertiesFile).copyTo(target);
        this.println("exported: " + modulePropertiesFile);
    }

    private void exportFile(String module, String ezyplatformHome, String targetFolder, String targetModuleName, String filePath) {
        Path fullFilePath;
        if (filePath == null || filePath.endsWith(".DS_Store")) {
            return;
        }
        Path path = fullFilePath = module != null ? Paths.get(module, filePath) : Paths.get(filePath, new String[0]);
        if (!Files.exists(fullFilePath, new LinkOption[0])) {
            return;
        }
        Path target = Paths.get(ezyplatformHome, targetFolder, targetModuleName, filePath);
        new PathFileProxy(fullFilePath).copyTo(target);
        System.out.println("exported: " + module + "/" + filePath);
    }

    private void exportResources(String module, String ezyplatformHome, String targetFolder, String targetModuleName) throws Exception {
        Path resourcesFolder = module != null ? Paths.get(module, PATH_RESOURCES) : Paths.get(PATH_RESOURCES, new String[0]);
        this.println("export: " + resourcesFolder);
        Path target = Paths.get(ezyplatformHome, targetFolder, targetModuleName, FOLDER_RESOURCES);
        EzyDirectories.deleteFolder((File)target.toFile());
        new PathFolderProxy(resourcesFolder).copyTo(target.toString(), path -> !path.endsWith(".DS_Store"), it -> this.println("exported: " + it));
    }

    private void exportLibs(String module, String ezyplatformHome, String targetFolder, String targetModuleName, String version) throws Exception {
        File artifacts = this.findArtifacts(module, version);
        if (artifacts == null) {
            return;
        }
        Path targetLibFolder = Paths.get(ezyplatformHome, targetFolder, targetModuleName, FOLDER_LIB);
        EzyDirectories.deleteFolder((File)targetLibFolder.toFile());
        if (artifacts.isFile()) {
            Path target = Paths.get(targetLibFolder.toString(), artifacts.getName());
            new PathFileProxy(artifacts.toPath()).copyTo(target);
            return;
        }
        Set<String> defaultLibNames = new PathFolderProxy(Paths.get(ezyplatformHome, FOLDER_LIB)).getJavaLibOnlyNames();
        Map<String, Path> moduleLibs = new PathFolderProxy(artifacts.toPath()).getJavaLibNames();
        for (String libName : moduleLibs.keySet()) {
            String libOnlyName = LibExtractor.extractLibName(libName);
            if (defaultLibNames.contains(libOnlyName)) continue;
            Path libPath = moduleLibs.get(libName);
            Path target = Paths.get(targetLibFolder.toString(), libPath.getFileName().toString());
            new PathFileProxy(libPath).copyTo(target);
            this.println("exported: " + libPath);
        }
    }

    private void exportSystemDependencies(String ezyplatformHome, String targetFolder, String targetModuleName, Set<String> systemDependencies) {
        Path targetLibFolder = Paths.get(ezyplatformHome, targetFolder, targetModuleName, FOLDER_LIB);
        for (String dependency : systemDependencies) {
            Path dependencyPath = Paths.get(dependency, new String[0]);
            if (Files.exists(dependencyPath, new LinkOption[0])) {
                Path target = Paths.get(targetLibFolder.toString(), dependencyPath.getFileName().toString());
                new PathFileProxy(dependencyPath).copyTo(target);
                this.println("exported: " + dependencyPath);
                continue;
            }
            this.println("not found: " + dependencyPath);
        }
    }

    private File findArtifacts(String module, String version) {
        File answer = null;
        String moduleFolder = FileNameProxy.getModuleFolderName(module);
        File targetFolder = (module != null ? Paths.get(module, "target") : Paths.get("target", new String[0])).toFile();
        if (targetFolder.exists()) {
            answer = Paths.get(targetFolder.toString(), moduleFolder + "-" + version + "-bin", FOLDER_LIB).toFile();
            if (!answer.exists()) {
                answer = Paths.get(targetFolder.toString(), moduleFolder + "-" + version + ".jar").toFile();
            }
            if (!answer.exists()) {
                answer = null;
            }
        }
        return answer;
    }

    private void exportDependenciesXmlFile(String ezyplatformHome, String projectName) {
        for (ModuleType moduleType : ModuleType.values()) {
            for (String buildFolder : SdkConstants.BUILD_FOLDER_NAMES) {
                Path dependenciesFilePath = Paths.get(Paths.get(buildFolder, new String[0]).toString(), "project", projectName, moduleType.getTargetFolder(), projectName, "dependencies.xml");
                if (!Files.exists(dependenciesFilePath, new LinkOption[0])) continue;
                Path targetFile = Paths.get(ezyplatformHome, moduleType.getTargetFolder(), projectName, "dependencies.xml");
                new PathFileProxy(dependenciesFilePath).copyTo(targetFile);
                this.println("exported: " + dependenciesFilePath);
                return;
            }
        }
    }
}

