/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.io.EzyCollections;
import java.util.HashSet;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.LinkArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;

public class LinkCommandHandler
extends AbstractCommandHandler<LinkArguments> {
    @Override
    public String handle(LinkArguments args) throws Exception {
        String linkProject = args.getLinkProjectName();
        this.newProjectDependenciesLinker().link(linkProject, EzyCollections.isEmpty(args.getModuleTypes()) ? Sets.newHashSet((Object[])ModuleType.values()) : args.getModuleTypes());
        return "linked with " + linkProject;
    }

    @Override
    public LinkArguments parse(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("missing project name, run help to see how to link a project");
        }
        String projectName = args[0];
        if (!projectName.matches("[a-zA-Z0-9\\-\\s]{2,60}")) {
            throw new IllegalArgumentException("invalid project name, run help to see how to link a project");
        }
        HashSet<ModuleType> moduleTypes = new HashSet<ModuleType>();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-m") && i < args.length - 1) {
                moduleTypes.addAll(this.extractModuleType(args[i + 1]));
                ++i;
                continue;
            }
            throw new IllegalArgumentException("unknown option: " + args[i] + ", run help to see how to link a project");
        }
        return LinkArguments.builder().linkProjectName(projectName).moduleTypes(moduleTypes).build();
    }
}

