/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlReader {
    public static void writeToFile(Document document, String filePath) throws Exception {
        XmlReader.writeToFile(document, filePath, Function.identity());
    }

    public static void writeToFile(Document document, String filePath, Function<String, String> contentDecorator) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(document);
        try (StringWriter writer = new StringWriter();){
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            String content = contentDecorator.apply(writer.getBuffer().toString());
            Files.write(Paths.get(filePath, new String[0]), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public static Node getFirstChildOfElement(Document parent, String childTagName) {
        NodeList nodeList = parent.getElementsByTagName(childTagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getParentNode() != parent.getDocumentElement()) continue;
            return node;
        }
        return null;
    }

    public static Node getFirstChildOfElement(Document parent, String elementTagName, String childTagName) {
        NodeList nodeList = parent.getElementsByTagName(elementTagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList childNodes;
            Element element = (Element)nodeList.item(i);
            if (element.getParentNode() != parent.getDocumentElement() || (childNodes = element.getElementsByTagName(childTagName)).getLength() <= 0) continue;
            return childNodes.item(0);
        }
        return null;
    }

    public static Node getFirstChildOfElement(Element parent, String childTagName) {
        NodeList nodeList = parent.getElementsByTagName(childTagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getParentNode() != parent) continue;
            return node;
        }
        return null;
    }

    public static List<Node> getChildrenOfElement(Document parent, String elementTagName) {
        if (parent == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = parent.getElementsByTagName(elementTagName);
        if (nodeList == null) {
            return Collections.emptyList();
        }
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            NodeList childNodes = element.getChildNodes();
            for (int k = 0; k < childNodes.getLength(); ++k) {
                Node child = childNodes.item(k);
                children.add(child);
            }
        }
        return children;
    }

    public static List<Element> getChildrenOfElement(Document parent, String elementTagName, String childTagName) {
        if (parent == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = parent.getElementsByTagName(elementTagName);
        if (nodeList == null) {
            return Collections.emptyList();
        }
        ArrayList<Element> children = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (element.getParentNode() != parent.getDocumentElement()) continue;
            NodeList childNodes = element.getElementsByTagName(childTagName);
            for (int k = 0; k < childNodes.getLength(); ++k) {
                Node child = childNodes.item(k);
                children.add((Element)child);
            }
        }
        return children;
    }

    public static String getElementTextContent(Element parent, String elementTagName) {
        NodeList childNodes = parent.getElementsByTagName(elementTagName);
        return childNodes.getLength() == 0 ? null : childNodes.item(0).getTextContent();
    }
}

