/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.ExportJavaDocsArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFileProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFolderProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PomXmlReaders;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ProjectNameFetcher;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ZipDirectory;

public class ExportJavaDocsCommandHandler
extends AbstractCommandHandler<ExportJavaDocsArguments> {
    @Override
    public String handle(ExportJavaDocsArguments args) throws Exception {
        String moduleName;
        File projectFolder = new File(".");
        String version = PomXmlReaders.getProjectVersionFromPomOrThrow(projectFolder);
        HashMap<String, Path> javaDocsFileByModuleName = new HashMap<String, Path>();
        File[] moduleFolders = projectFolder.listFiles();
        if (moduleFolders != null) {
            HashSet<String> inclusiveModuleNames = new HashSet<String>(args.getInclusiveModuleNames());
            inclusiveModuleNames.removeAll(args.getExclusiveModuleNames());
            for (File moduleFolder : moduleFolders) {
                Path javaDocsFile;
                moduleName = moduleFolder.getName();
                if (inclusiveModuleNames.size() > 0 && !inclusiveModuleNames.contains(moduleName) || !Files.exists(javaDocsFile = Paths.get(moduleFolder.toString(), "target", moduleName + "-" + version + "-javadoc.jar"), new LinkOption[0])) continue;
                javaDocsFileByModuleName.put(moduleName, javaDocsFile);
            }
        }
        if (javaDocsFileByModuleName.isEmpty()) {
            return "no java docs to export";
        }
        String projectName = ProjectNameFetcher.getProjectName();
        Path targetProjectFolder = Paths.get(projectFolder.toString(), "target", "project");
        Path targetContainerFolder = targetProjectFolder.resolve(projectName + "-" + version + "-docs");
        for (Map.Entry e : javaDocsFileByModuleName.entrySet()) {
            moduleName = (String)e.getKey();
            Path apidocsFolder = Paths.get(projectFolder.toString(), moduleName, "target", "apidocs");
            Path targetModuleFolder = targetContainerFolder.resolve(moduleName);
            if (Files.exists(apidocsFolder, new LinkOption[0])) {
                this.println("export " + apidocsFolder);
                this.exportApidocsFolder(apidocsFolder, targetModuleFolder);
                continue;
            }
            Path javaDocsFile = (Path)e.getValue();
            this.println("export " + javaDocsFile);
            this.extractJavaDocsFile(javaDocsFile, targetModuleFolder);
        }
        File outputZipFile = new File(targetContainerFolder + ".zip");
        ZipDirectory.builder().dirToZip(targetContainerFolder.toFile()).outputZipFile(outputZipFile).build().zip();
        return "exported java docs: " + outputZipFile;
    }

    private void exportApidocsFolder(Path apidocsFolder, Path targetModuleFolder) {
        new PathFolderProxy(apidocsFolder).copyTo(targetModuleFolder.toString(), path -> !path.endsWith(".DS_Store"), it -> {});
    }

    private void extractJavaDocsFile(Path javaDocsFile, Path targetModuleFolder) throws Exception {
        JarFile jar = new JarFile(javaDocsFile.toFile());
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry entry = enumEntries.nextElement();
            Path extractedFile = targetModuleFolder.resolve(entry.getName());
            if (entry.isDirectory()) {
                PathFolderProxy.createFolder(extractedFile);
                continue;
            }
            PathFileProxy.createFile(extractedFile);
            InputStream is = jar.getInputStream(entry);
            FileOutputStream fos = new FileOutputStream(extractedFile.toFile());
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
        jar.close();
    }

    @Override
    public ExportJavaDocsArguments parse(String[] args) throws Exception {
        HashSet<String> inclusiveModuleNames = new HashSet<String>();
        HashSet<String> exclusiveModuleNames = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-i") && i < args.length - 1) {
                inclusiveModuleNames.addAll(this.extractMultiValuesArg(args[i + 1]));
                ++i;
                continue;
            }
            if (args[i].equals("-e") && i < args.length - 1) {
                exclusiveModuleNames.addAll(this.extractMultiValuesArg(args[i + 1]));
                ++i;
                continue;
            }
            throw new IllegalArgumentException("unknown option: " + args[i] + ", run help to see how to export java docs");
        }
        return ExportJavaDocsArguments.builder().inclusiveModuleNames(inclusiveModuleNames).exclusiveModuleNames(exclusiveModuleNames).build();
    }
}

