/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.arguments;

import com.tvd12.ezyfox.io.EzyStrings;
import java.util.HashSet;
import java.util.Set;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.Arguments;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;

public class CreateProjectArguments
implements Arguments {
    private String projectName;
    private String groupName;
    private String packageName;
    private String version;
    private Set<ModuleType> inclusiveModuleTypes;
    private Set<ModuleType> exclusiveModuleTypes;
    private String author;
    private String outputDirectory;

    public String getProjectName() {
        return EzyStrings.toDashCase((String)this.projectName.toLowerCase().replace(' ', '-'));
    }

    public String getProjectDisplayName() {
        return EzyStrings.toDisplayName((String)this.projectName);
    }

    public String getProjectNameUnderscoreCase() {
        return EzyStrings.toUnderscoreCase((String)this.projectName.toLowerCase());
    }

    public String getProjectUpperCase() {
        return this.getProjectDisplayName().replace(" ", "");
    }

    public String getPackageName() {
        return EzyStrings.isNotBlank((String)this.packageName) ? this.packageName : this.groupName + "." + EzyStrings.toUnderscoreCase((String)this.projectName.toLowerCase());
    }

    public Set<ModuleType> getModuleTypes() {
        HashSet<ModuleType> answer = new HashSet<ModuleType>(this.inclusiveModuleTypes);
        answer.removeAll(this.exclusiveModuleTypes);
        return answer;
    }

    public String getAuthor() {
        return this.author != null ? this.author : System.getProperty("user.name");
    }

    public String toString() {
        return "CreateProjectArguments{projectName='" + this.getProjectName() + "', projectDisplayName='" + this.getProjectDisplayName() + "', groupName='" + this.groupName + "', packageName='" + this.packageName + "', inclusiveModuleTypes=" + this.inclusiveModuleTypes + "', exclusiveModuleTypes=" + this.exclusiveModuleTypes + "', author='" + this.author + "', outputDirectory='" + this.outputDirectory + '\'' + '}';
    }

    CreateProjectArguments(String projectName, String groupName, String packageName, String version, Set<ModuleType> inclusiveModuleTypes, Set<ModuleType> exclusiveModuleTypes, String author, String outputDirectory) {
        this.projectName = projectName;
        this.groupName = groupName;
        this.packageName = packageName;
        this.version = version;
        this.inclusiveModuleTypes = inclusiveModuleTypes;
        this.exclusiveModuleTypes = exclusiveModuleTypes;
        this.author = author;
        this.outputDirectory = outputDirectory;
    }

    public static CreateProjectArgumentsBuilder builder() {
        return new CreateProjectArgumentsBuilder();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public static class CreateProjectArgumentsBuilder {
        private String projectName;
        private String groupName;
        private String packageName;
        private String version;
        private Set<ModuleType> inclusiveModuleTypes;
        private Set<ModuleType> exclusiveModuleTypes;
        private String author;
        private String outputDirectory;

        CreateProjectArgumentsBuilder() {
        }

        public CreateProjectArgumentsBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public CreateProjectArgumentsBuilder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public CreateProjectArgumentsBuilder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public CreateProjectArgumentsBuilder version(String version) {
            this.version = version;
            return this;
        }

        public CreateProjectArgumentsBuilder inclusiveModuleTypes(Set<ModuleType> inclusiveModuleTypes) {
            this.inclusiveModuleTypes = inclusiveModuleTypes;
            return this;
        }

        public CreateProjectArgumentsBuilder exclusiveModuleTypes(Set<ModuleType> exclusiveModuleTypes) {
            this.exclusiveModuleTypes = exclusiveModuleTypes;
            return this;
        }

        public CreateProjectArgumentsBuilder author(String author) {
            this.author = author;
            return this;
        }

        public CreateProjectArgumentsBuilder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public CreateProjectArguments build() {
            return new CreateProjectArguments(this.projectName, this.groupName, this.packageName, this.version, this.inclusiveModuleTypes, this.exclusiveModuleTypes, this.author, this.outputDirectory);
        }

        public String toString() {
            return "CreateProjectArguments.CreateProjectArgumentsBuilder(projectName=" + this.projectName + ", groupName=" + this.groupName + ", packageName=" + this.packageName + ", version=" + this.version + ", inclusiveModuleTypes=" + this.inclusiveModuleTypes + ", exclusiveModuleTypes=" + this.exclusiveModuleTypes + ", author=" + this.author + ", outputDirectory=" + this.outputDirectory + ")";
        }
    }
}

