/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import com.tvd12.ezyfox.io.EzyStrings;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.CurrentVersionArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PomXmlReaders;

public class CurrentVersionCommandHandler
extends AbstractCommandHandler<CurrentVersionArguments> {
    @Override
    public String handle(CurrentVersionArguments args) throws Exception {
        String targetProjectFolder = args.getTargetProjectFolder();
        Path projectDir = Paths.get(EzyStrings.isBlank((String)targetProjectFolder) ? "" : targetProjectFolder, new String[0]);
        return PomXmlReaders.getProjectVersionFromPomOrThrow(projectDir.toFile());
    }

    @Override
    public CurrentVersionArguments parse(String[] args) {
        String targetProjectFolder = null;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-t") && i < args.length - 1) {
                    targetProjectFolder = args[i + 1];
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException("unknown option: " + args[i] + ", run help to see how to get current project's version");
            }
        }
        return new CurrentVersionArguments(targetProjectFolder);
    }
}

