/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFolderProxy;

public class PathFileProxy {
    private final Path path;

    public static void createFile(Path file) {
        if (file != null && !Files.exists(file, new LinkOption[0])) {
            Path parent = file.getParent();
            PathFolderProxy.createFolder(parent);
            try {
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not create file: " + file + ", please check your permission");
            }
        }
    }

    public void copyTo(Path targetFile) {
        PathFileProxy.createFile(targetFile);
        try (FileInputStream inputStream = new FileInputStream(this.path.toFile());
             FileOutputStream outputStream = new FileOutputStream(targetFile.toFile());){
            int readBytes;
            byte[] buffer = new byte[1024];
            while ((readBytes = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, readBytes);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not copy file: " + this.path + " to " + targetFile + ": " + e.getMessage() + ", please check your permission");
        }
    }

    public PathFileProxy(Path path) {
        this.path = path;
    }
}

