/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.util.EzyReturner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class EzyFolderTreePrinter {
    protected boolean pretty;
    protected boolean printFile;
    protected String tabsString;
    protected String branchString;
    protected String verticalSymbol;

    protected EzyFolderTreePrinter(Builder builder) {
        this.pretty = builder.pretty;
        this.printFile = builder.printFile;
        this.tabsString = builder.printTabs();
        this.branchString = builder.printBranch();
        this.verticalSymbol = builder.verticalSymbol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String print(File folder) {
        EzyFile root = new EzyFile(folder);
        this.visitFile(root, folder);
        StringBuilder sb = new StringBuilder();
        this.print(root, sb);
        return sb.toString();
    }

    private void print(EzyFile file, StringBuilder sb) {
        String first = file.getParent() != null ? this.branchString : "";
        sb.append(this.printIndents(file)).append(first).append(file.getName()).append(file.isFile() ? "" : "/").append("\n");
        for (EzyFile child : file.getChildren()) {
            this.print(child, sb);
        }
    }

    private String printIndents(EzyFile file) {
        ArrayList<String> strings = new ArrayList<String>();
        for (EzyFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            boolean vertical = this.pretty && parent.isLastFileInFolder();
            strings.add((vertical ? "" : this.verticalSymbol) + this.tabsString);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = strings.size() - 1; i >= 0; --i) {
            sb.append((String)strings.get(i));
        }
        return sb.toString();
    }

    private void visitFile(EzyFile parent, File file) {
        if (file.isFile()) {
            if (this.printFile) {
                EzyFile item = new EzyFile(file);
                item.setParent(parent);
            }
        } else {
            File[] files = EzyReturner.returnNotNull(file.listFiles(), new File[0]);
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile() && !this.printFile) continue;
                EzyFile item = new EzyFile(files[i]);
                this.visitFile(item, files[i]);
                item.setParent(parent);
                item.setLastFileInFolder(i == files.length - 1);
            }
        }
    }

    private static class EzyFile {
        private final String name;
        private final boolean file;
        private EzyFile parent;
        private boolean lastFileInFolder = true;
        private final List<EzyFile> children = new ArrayList<EzyFile>();

        public EzyFile(File file) {
            this.file = file.isFile();
            this.name = file.getName();
        }

        public void setParent(EzyFile parent) {
            if (!parent.isFile()) {
                parent.addChild(this);
            }
            this.parent = parent;
        }

        public void addChild(EzyFile child) {
            this.children.add(child);
        }

        public String getName() {
            return this.name;
        }

        public boolean isFile() {
            return this.file;
        }

        public EzyFile getParent() {
            return this.parent;
        }

        public boolean isLastFileInFolder() {
            return this.lastFileInFolder;
        }

        public List<EzyFile> getChildren() {
            return this.children;
        }

        public void setLastFileInFolder(boolean lastFileInFolder) {
            this.lastFileInFolder = lastFileInFolder;
        }
    }

    public static class Builder
    implements EzyBuilder<EzyFolderTreePrinter> {
        protected int tabSize = 2;
        protected boolean pretty = true;
        protected boolean printFile = true;
        protected String verticalSymbol = "|";
        protected String horizontalSymbol = "-";
        protected String intersectionSymbol = "+";

        public Builder tabSize(int tabSize) {
            this.tabSize = tabSize;
            return this;
        }

        public Builder pretty(boolean pretty) {
            this.pretty = pretty;
            return this;
        }

        public Builder printFile(boolean printFile) {
            this.printFile = printFile;
            return this;
        }

        public Builder verticalSymbol(String verticalSymbol) {
            this.verticalSymbol = verticalSymbol;
            return this;
        }

        public Builder horizontalSymbol(String horizontalSymbol) {
            this.horizontalSymbol = horizontalSymbol;
            return this;
        }

        public Builder intersectionSymbol(String intersectionSymbol) {
            this.intersectionSymbol = intersectionSymbol;
            return this;
        }

        @Override
        public EzyFolderTreePrinter build() {
            return new EzyFolderTreePrinter(this);
        }

        private String printTabs() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.tabSize; ++i) {
                builder.append(" ");
            }
            return builder.toString();
        }

        private String printBranch() {
            StringBuilder builder = new StringBuilder(this.intersectionSymbol);
            for (int i = 0; i < this.tabSize; ++i) {
                builder.append(this.horizontalSymbol);
            }
            return builder.toString();
        }
    }
}

