/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.constant;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfox.util.EzyEnums;
import java.util.Map;

public enum EzyLogLevel implements EzyConstant
{
    TRACE(1, "trace"),
    DEBUG(2, "debug"),
    INFO(3, "info"),
    WARN(4, "warn"),
    ERROR(5, "error"),
    FATAL(6, "fatal");

    private final int id;
    private final String name;
    private static final Map<String, EzyLogLevel> MAP_BY_NAME;

    private EzyLogLevel(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static EzyLogLevel ofName(String name) {
        return MAP_BY_NAME.get(name);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    static {
        MAP_BY_NAME = EzyEnums.enumMap(EzyLogLevel.class, it -> it.name);
    }
}

