/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.builder.EzyBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class EzyObjectProxy {
    protected final Map<String, String> propertyKeys;
    protected final Map<String, Class<?>> propertyTypes;
    protected final Map<String, Function<Object, Object>> getters;
    protected final Map<String, BiConsumer<Object, Object>> setters;

    protected EzyObjectProxy(Builder builder) {
        this.setters = builder.setters;
        this.getters = builder.getters;
        this.propertyKeys = builder.propertyKeys;
        this.propertyTypes = builder.propertyTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPropertyName(String key) {
        return this.propertyKeys.get(key);
    }

    public Class<?> getPropertyType(String property) {
        return this.propertyTypes.get(property);
    }

    public <T> T getProperty(Object object, String property) {
        Function<Object, Object> getter = this.getters.get(property);
        if (getter != null) {
            return (T)getter.apply(object);
        }
        return null;
    }

    public void setProperty(Object object, String property, Object value) {
        BiConsumer<Object, Object> setter = this.setters.get(property);
        if (setter != null) {
            setter.accept(object, value);
        }
    }

    public static class Builder
    implements EzyBuilder<EzyObjectProxy> {
        protected Map<String, String> propertyKeys;
        protected Map<String, Class<?>> propertyTypes;
        protected Map<String, Function<Object, Object>> getters;
        protected Map<String, BiConsumer<Object, Object>> setters = new HashMap<String, BiConsumer<Object, Object>>();

        public Builder() {
            this.getters = new HashMap<String, Function<Object, Object>>();
            this.propertyKeys = new HashMap<String, String>();
            this.propertyTypes = new HashMap();
        }

        public Builder propertyKey(String key, String property) {
            this.propertyKeys.put(key, property);
            return this;
        }

        public Builder propertyKey(Map<String, String> propertyKeys) {
            this.propertyKeys.putAll(propertyKeys);
            return this;
        }

        public Builder addPropertyType(String property, Class<?> type) {
            this.propertyTypes.put(property, type);
            return this;
        }

        public Builder addPropertyTypes(Map<String, Class<?>> propertyTypes) {
            this.propertyTypes.putAll(propertyTypes);
            return this;
        }

        public Builder addGetters(Map<String, Function<Object, Object>> setters) {
            this.getters.putAll(setters);
            return this;
        }

        public Builder addGetter(String property, Function<Object, Object> getter) {
            this.getters.put(property, getter);
            return this;
        }

        public Builder addSetters(Map<String, BiConsumer<Object, Object>> setters) {
            this.setters.putAll(setters);
            return this;
        }

        public Builder addSetter(String property, BiConsumer<Object, Object> setter) {
            this.setters.put(property, setter);
            return this;
        }

        @Override
        public EzyObjectProxy build() {
            for (String key : this.propertyKeys.keySet()) {
                String property = this.propertyKeys.get(key);
                this.getters.put(key, this.getters.get(property));
                this.setters.put(key, this.setters.get(property));
                this.propertyTypes.put(key, this.propertyTypes.get(property));
            }
            return new EzyObjectProxy(this);
        }
    }
}

