/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import com.tvd12.ezyfox.constant.EzyLogLevel;
import com.tvd12.ezyfox.function.EzyExceptionVoid;
import com.tvd12.ezyfox.function.EzyVoid;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EzyProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EzyProcessor.class);

    private EzyProcessor() {
    }

    public static void processSilently(EzyExceptionVoid applier) {
        try {
            applier.apply();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void processWithException(EzyExceptionVoid applier) {
        EzyProcessor.processWithException(applier, IllegalStateException::new);
    }

    public static void processWithException(EzyExceptionVoid applier, Function<Throwable, RuntimeException> handler) {
        try {
            applier.apply();
        }
        catch (Exception e) {
            throw handler.apply(e);
        }
    }

    public static void processWithIllegalArgumentException(EzyExceptionVoid applier) {
        EzyProcessor.processWithException(applier, IllegalArgumentException::new);
    }

    public static void processWithLogException(EzyExceptionVoid applier) {
        EzyProcessor.processWithLogException(applier, false);
    }

    public static void processWithLogException(EzyExceptionVoid applier, boolean warn) {
        EzyProcessor.processWithLogException(applier, warn ? EzyLogLevel.WARN : EzyLogLevel.INFO);
    }

    public static void processWithLogException(EzyExceptionVoid applier, EzyLogLevel logLevel) {
        try {
            applier.apply();
        }
        catch (Exception e) {
            if (logLevel == EzyLogLevel.TRACE) {
                LOGGER.trace("can't process " + applier, (Throwable)e);
            }
            if (logLevel == EzyLogLevel.DEBUG) {
                LOGGER.debug("can't process " + applier, (Throwable)e);
            }
            if (logLevel == EzyLogLevel.INFO) {
                LOGGER.info("can't process " + applier, (Throwable)e);
            }
            if (logLevel == EzyLogLevel.WARN) {
                LOGGER.warn("can't process " + applier, (Throwable)e);
            }
            LOGGER.error("can't process " + applier, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processWithSync(EzyVoid applier, Object context) {
        Object object = context;
        synchronized (object) {
            applier.apply();
        }
    }

    public static void processWithLock(EzyVoid applier, Lock lock) {
        lock.lock();
        try {
            applier.apply();
        }
        finally {
            lock.unlock();
        }
    }

    public static void processWithTryLock(EzyVoid applier, Lock lock) {
        if (!lock.tryLock()) {
            return;
        }
        try {
            applier.apply();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processWithTryLock(EzyVoid applier, Lock lock, long time) throws InterruptedException {
        if (!EzyProcessor.tryLock(lock, time)) {
            return;
        }
        try {
            applier.apply();
        }
        finally {
            lock.unlock();
        }
    }

    private static boolean tryLock(Lock lock, long time) throws InterruptedException {
        return lock.tryLock(time, TimeUnit.MILLISECONDS);
    }
}

