/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.util.EzyEntry;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.XmlReader;

public class SystemDependenciesFetcher {
    private static final String EZYPLATFORM_HOME_PREFIX = "${ezyplatform.home}";
    private static final Map<ModuleType, Set<ModuleType>> EXTERNAL_MODULE_TYPE_MAP = EzyMapBuilder.mapBuilder().put((Object)ModuleType.ADMIN_PLUGIN, (Object)Sets.newHashSet((Object[])new ModuleType[]{ModuleType.SOCKET_APP, ModuleType.SOCKET_PLUGIN, ModuleType.THEME, ModuleType.WEB_PLUGIN})).put((Object)ModuleType.SOCKET_APP, (Object)Sets.newHashSet((Object[])new ModuleType[]{ModuleType.ADMIN_PLUGIN, ModuleType.THEME, ModuleType.WEB_PLUGIN})).put((Object)ModuleType.SOCKET_PLUGIN, (Object)Sets.newHashSet((Object[])new ModuleType[]{ModuleType.ADMIN_PLUGIN, ModuleType.THEME, ModuleType.WEB_PLUGIN})).put((Object)ModuleType.THEME, (Object)Sets.newHashSet((Object[])new ModuleType[]{ModuleType.ADMIN_PLUGIN, ModuleType.SOCKET_APP, ModuleType.SOCKET_PLUGIN})).put((Object)ModuleType.WEB_PLUGIN, (Object)Sets.newHashSet((Object[])new ModuleType[]{ModuleType.ADMIN_PLUGIN, ModuleType.SOCKET_APP, ModuleType.SOCKET_PLUGIN})).toMap();

    public Map<String, Set<String>> getSystemDependenciesMapToModule(String projectFolder) throws Exception {
        Path projectPomFilePath = FileProxy.getProjectPomFileOrThrow(projectFolder);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Map<String, String> propertyValueByName = this.readProjectPomProperties(builder, projectPomFilePath);
        Set moduleTypes = Sets.newHashSet((Object[])ModuleType.values());
        Map<ModuleType, Map<String, String>> pomFileByFolderMapByModuleType = FileProxy.getInclusivePomFileMap(projectFolder, moduleTypes);
        return pomFileByFolderMapByModuleType.entrySet().stream().flatMap(it -> ((Map)it.getValue()).entrySet().stream().map(e -> EzyEntry.of(e.getKey(), this.getSystemDependencyFilePaths(builder, (ModuleType)((Object)((Object)((Object)it.getKey()))), (String)e.getValue(), propertyValueByName)))).collect(Collectors.toMap(Map.Entry::getKey, EzyEntry::getValue, (o, n) -> n));
    }

    private Map<String, String> readProjectPomProperties(DocumentBuilder builder, Path projectPomFile) throws Exception {
        Document projectPomDocument = builder.parse(projectPomFile.toFile());
        List<Node> propertyNodes = XmlReader.getChildrenOfElement(projectPomDocument, "properties");
        HashMap<String, String> propertyValueByName = new HashMap<String, String>(propertyNodes.stream().filter(it -> it.getNodeType() == 1).filter(it -> it.getTextContent() != null).collect(Collectors.toMap(Node::getNodeName, Node::getTextContent, (o, n) -> n)));
        propertyValueByName.put("ezyplatform.home", FileProxy.getEzyPlatformHome());
        return propertyValueByName;
    }

    private Set<String> getSystemDependencyFilePaths(DocumentBuilder builder, ModuleType moduleType, String pomFilePath, Map<String, String> propertyValueByName) {
        try {
            Document pomDocument = builder.parse(pomFilePath);
            List<Element> dependencies = XmlReader.getChildrenOfElement(pomDocument, "dependencies", "dependency");
            Set<ModuleType> externalModuleType = EXTERNAL_MODULE_TYPE_MAP.get((Object)moduleType);
            return dependencies.stream().map(it -> it.getElementsByTagName("systemPath")).filter(it -> it.getLength() > 0).map(it -> it.item(0)).map(Node::getTextContent).map(it -> {
                ModuleType mt = this.getModuleTypeFromSystemPath((String)it);
                return mt != null && externalModuleType.contains((Object)mt) ? this.setSystemPathVariables((String)it, propertyValueByName) : null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (Exception e) {
            throw new IllegalStateException("get system dependency file of: " + pomFilePath + " error", e);
        }
    }

    private ModuleType getModuleTypeFromSystemPath(String systemPath) {
        for (ModuleType moduleType : ModuleType.values()) {
            String prefix = "${ezyplatform.home}/" + moduleType.getTargetFolder() + "/";
            if (!systemPath.startsWith(prefix)) continue;
            return moduleType;
        }
        return null;
    }

    private String setSystemPathVariables(String systemPath, Map<String, String> propertyValueByName) {
        String answer = systemPath;
        for (Map.Entry<String, String> e : propertyValueByName.entrySet()) {
            answer = answer.replace("${" + e.getKey() + "}", e.getValue());
        }
        return answer.trim();
    }
}

