/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;

public final class EzyClasses {
    private static final String DOT = ".";

    private EzyClasses() {
    }

    public static String getSimpleName(Class clazz) {
        String simpleName = clazz.getSimpleName();
        if (!simpleName.isEmpty()) {
            return simpleName;
        }
        String fullName = clazz.getName();
        if (!fullName.contains(DOT)) {
            return fullName;
        }
        return fullName.substring(fullName.lastIndexOf(DOT) + 1);
    }

    public static String getVariableName(Class clazz) {
        return EzyClasses.getVariableName(clazz, "");
    }

    public static String getVariableName(Class clazz, String ignoredSuffix) {
        String name = EzyClasses.getSimpleName(clazz);
        String vname = name.substring(0, 1).toLowerCase() + name.substring(1);
        if (ignoredSuffix.isEmpty() || !vname.endsWith(ignoredSuffix) || vname.length() == ignoredSuffix.length()) {
            return vname;
        }
        int endIndex = vname.indexOf(ignoredSuffix);
        return vname.substring(0, endIndex);
    }

    public static Class getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Class getClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T newInstance(String className) {
        return EzyClasses.newInstance(className, new Class[0], new Object[0]);
    }

    public static <T> T newInstance(String className, Class<?>[] constructorParameterTypes, Object[] constructorParameterValues) {
        try {
            return EzyClasses.getClass(className).getDeclaredConstructor(constructorParameterTypes).newInstance(constructorParameterValues);
        }
        catch (Exception e) {
            try {
                return EzyClasses.getClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public static <T> T newInstance(String className, ClassLoader classLoader) {
        try {
            return EzyClasses.getClass(className, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredConstructor(paramTypes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Set<Class> flatSuperClasses(Class clazz) {
        return EzyClasses.flatSuperClasses(clazz, false);
    }

    public static Set<Class> flatSuperClasses(Class clazz, boolean includeObject) {
        HashSet<Class> classes = new HashSet<Class>();
        for (Class superClass = clazz.getSuperclass(); superClass != null && (!superClass.equals(Object.class) || includeObject); superClass = superClass.getSuperclass()) {
            classes.add(superClass);
        }
        return classes;
    }

    public static Set<Class> flatInterfaces(Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        HashSet<Class> classes = new HashSet<Class>(Sets.newHashSet(interfaces));
        for (Class<?> itf : interfaces) {
            classes.addAll(EzyClasses.flatInterfaces(itf));
        }
        return classes;
    }

    public static Set<Class> flatSuperAndInterfaceClasses(Class clazz) {
        return EzyClasses.flatSuperAndInterfaceClasses(clazz, false);
    }

    public static Set<Class> flatSuperAndInterfaceClasses(Class clazz, boolean includeObject) {
        Set<Class> interfaces = EzyClasses.flatInterfaces(clazz);
        Set<Class> superClasses = EzyClasses.flatSuperClasses(clazz, includeObject);
        HashSet<Class> classes = new HashSet<Class>(interfaces);
        for (Class superClass : superClasses) {
            Set<Class> superAndInterfaceClasses = EzyClasses.flatSuperAndInterfaceClasses(superClass, includeObject);
            classes.add(superClass);
            classes.addAll(superAndInterfaceClasses);
        }
        return classes;
    }

    public static boolean isAnnotationPresentIncludeSuper(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        while (clazz != Object.class) {
            if (clazz.isAnnotationPresent(annotationClass)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }
}

