/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.IntStream;

public final class EzyCollections {
    private EzyCollections() {
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static <T> T[] toArray(Collection<T> coll, IntFunction<T[]> applier) {
        return coll.toArray(applier.apply(coll.size()));
    }

    public static boolean containsAny(Collection<?> c1, Collection<?> c2) {
        return c2.stream().anyMatch(c1::contains);
    }

    public static <T> int countItems(Collection<T> coll, Predicate<T> predicate) {
        return (int)coll.stream().filter(predicate).count();
    }

    public static <T> double sumItemsToDouble(Collection<T> coll, ToDoubleFunction<T> mapper) {
        return coll.stream().mapToDouble(mapper).sum();
    }

    public static <T> int sumItemsToInt(Collection<T> coll, ToIntFunction<T> mapper) {
        return coll.stream().mapToInt(mapper).sum();
    }

    public static <T> long sumItemsToLong(Collection<T> coll, ToLongFunction<T> mapper) {
        return coll.stream().mapToLong(mapper).sum();
    }

    public static <T> int flatMapToInt(Collection<T> coll, Function<T, Integer> measurer) {
        return coll.stream().flatMapToInt(t -> IntStream.of((int)((Integer)measurer.apply(t)))).sum();
    }

    public static <T> T getItem(Collection<T> coll, Predicate<T> predicate) {
        for (T t : coll) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }
}

