/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import com.tvd12.ezyfox.util.EzyDirectories;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.Arguments;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.PackArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.data.BuildTool;
import org.youngmonkeys.ezyplatform.sdk.tools.data.LocalProperties;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleProperties;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.extractor.LibExtractor;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileNameProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.LocalPropertiesReader;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ModulePropertiesReader;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFileProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFolderProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ProjectNameFetcher;
import org.youngmonkeys.ezyplatform.sdk.tools.io.SystemDependenciesFetcher;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ZipDirectory;

public class PackCommandHandler
extends AbstractCommandHandler<PackArguments> {
    @Override
    public Arguments parse(String[] args) {
        if (args.length == 0) {
            return new PackArguments(null);
        }
        return new PackArguments(args[0].trim());
    }

    @Override
    public String handle(PackArguments args) throws Exception {
        boolean hasError = false;
        ExportModuleResult result = null;
        Map<String, Set<String>> systemDependenciesMapToModule = new SystemDependenciesFetcher().getSystemDependenciesMapToModule(new File(".").toString());
        String projectName = ProjectNameFetcher.getProjectName();
        for (String module : this.getModules(args)) {
            Set<String> systemDependencies = systemDependenciesMapToModule.getOrDefault(module, Collections.emptySet());
            ExportModuleResult exportResult = this.exportModule(module, projectName, systemDependencies);
            if (result == null) {
                result = exportResult;
            }
            if (!result.projectName.equals(exportResult.projectName)) {
                this.println("module: " + result.module + " has project name: " + result.projectName + ", but module: " + module + " has project name: " + exportResult.projectName);
                hasError = true;
            }
            if (result.version.equals(exportResult.version)) continue;
            this.println("module: " + result.module + " has version: " + result.version + ", but module: " + module + " has version: " + exportResult.version);
            hasError = true;
        }
        if (result == null) {
            return "nothing to export and package";
        }
        if (hasError) {
            return "please fix the error to continue";
        }
        String targetModulesFolder = this.getTargetModulesFolder(result.buildTool, result.projectName);
        for (ModuleType moduleType : ModuleType.values()) {
            Path targetFolder = Paths.get(targetModulesFolder, moduleType.getTargetFolder(), result.projectName);
            if (!Files.exists(targetFolder, new LinkOption[0])) continue;
            this.newProjectDependenciesWriter().write(projectName, targetFolder.toString());
            break;
        }
        this.zipModules(targetModulesFolder, result.projectName, result.version);
        return "";
    }

    private List<String> getModules(PackArguments args) {
        return this.getModules(args.getModule());
    }

    private ExportModuleResult exportModule(String module, String projectName, Set<String> systemDependencies) throws Exception {
        LocalProperties localProperties = new LocalPropertiesReader().read(module);
        String ezyplatformHome = this.getEzyPlatformHome(localProperties);
        ModuleProperties moduleProperties = new ModulePropertiesReader().read(module);
        String targetModulesFolder = this.getTargetModulesFolder(localProperties.getBuildTool(), projectName);
        String targetFolder = moduleProperties.getTargetFolder();
        String targetModuleName = moduleProperties.getTargetModuleName();
        String zoneSettingFile = moduleProperties.getZoneSettingFile();
        String descriptionFile = moduleProperties.getDescriptionFile();
        String settingsFile = moduleProperties.getSettingsFile();
        String menusFile = moduleProperties.getMenusFile();
        String version = moduleProperties.getVersion();
        this.exportModuleProperties(module, targetModulesFolder, targetFolder, targetModuleName);
        this.exportFile(module, targetModulesFolder, targetFolder, targetModuleName, zoneSettingFile);
        this.exportFile(module, targetModulesFolder, targetFolder, targetModuleName, descriptionFile);
        this.exportFile(module, targetModulesFolder, targetFolder, targetModuleName, settingsFile);
        this.exportFile(module, targetModulesFolder, targetFolder, targetModuleName, menusFile);
        this.exportFile(module, targetModulesFolder, targetFolder, targetModuleName, "swagger.yaml");
        this.exportResources(module, targetModulesFolder, targetFolder, targetModuleName);
        this.exportLibs(module, ezyplatformHome, targetModulesFolder, targetFolder, targetModuleName, version);
        this.exportSystemDependencies(targetModulesFolder, targetFolder, targetModuleName, systemDependencies);
        this.println("export successfully " + targetModuleName + " to " + Paths.get(targetModulesFolder, targetFolder));
        return ExportModuleResult.builder().projectName(projectName).module(module).version(moduleProperties.getVersion()).buildTool(localProperties.getBuildTool()).build();
    }

    private String getEzyPlatformHome(LocalProperties localProperties) {
        String answer = System.getenv("EZYPLATFORM_HOME");
        if (answer == null) {
            answer = localProperties.getEzyplatformHome();
        }
        return answer;
    }

    private void exportModuleProperties(String module, String targetModulesFolder, String targetFolder, String targetModuleName) {
        Path modulePropertiesFile = module != null ? Paths.get(module, "module.properties") : Paths.get("module.properties", new String[0]);
        Path target = Paths.get(targetModulesFolder, targetFolder, targetModuleName, "module.properties");
        new PathFileProxy(modulePropertiesFile).copyTo(target);
        this.println("exported: " + modulePropertiesFile);
    }

    private void exportFile(String module, String targetModulesFolder, String targetFolder, String targetModuleName, String filePath) {
        Path fullFilePath;
        if (filePath == null || filePath.endsWith(".DS_Store")) {
            return;
        }
        Path path = fullFilePath = module != null ? Paths.get(module, filePath) : Paths.get(filePath, new String[0]);
        if (!Files.exists(fullFilePath, new LinkOption[0])) {
            return;
        }
        Path target = Paths.get(targetModulesFolder, targetFolder, targetModuleName, filePath);
        new PathFileProxy(fullFilePath).copyTo(target);
        this.println("exported: " + filePath);
    }

    private void exportResources(String module, String targetModulesFolder, String targetFolder, String targetModuleName) throws Exception {
        Path resourcesFolder = module != null ? Paths.get(module, "src/main/resources") : Paths.get("src/main/resources", new String[0]);
        this.println("export: " + resourcesFolder);
        Path target = Paths.get(targetModulesFolder, targetFolder, targetModuleName, "resources");
        EzyDirectories.deleteFolder((File)target.toFile());
        new PathFolderProxy(resourcesFolder).copyTo(target.toString(), path -> !path.endsWith(".DS_Store"), it -> this.println("exported: " + it));
    }

    private void exportLibs(String module, String ezyplatformHome, String targetModulesFolder, String targetFolder, String targetModuleName, String version) throws Exception {
        File artifacts = this.findArtifacts(module, version);
        if (artifacts == null) {
            return;
        }
        Path targetLibFolder = Paths.get(targetModulesFolder, targetFolder, targetModuleName, "lib");
        EzyDirectories.deleteFolder((File)targetLibFolder.toFile());
        if (artifacts.isFile()) {
            Path target = Paths.get(targetLibFolder.toString(), artifacts.getName());
            new PathFileProxy(artifacts.toPath()).copyTo(target);
            return;
        }
        Set<String> defaultLibNames = new PathFolderProxy(Paths.get(ezyplatformHome, "lib")).getJavaLibOnlyNames();
        Map<String, Path> moduleLibs = new PathFolderProxy(artifacts.toPath()).getJavaLibNames();
        for (String libName : moduleLibs.keySet()) {
            String libOnlyName = LibExtractor.extractLibName(libName);
            if (defaultLibNames.contains(libOnlyName)) continue;
            Path libPath = moduleLibs.get(libName);
            Path target = Paths.get(targetLibFolder.toString(), libPath.getFileName().toString());
            new PathFileProxy(libPath).copyTo(target);
            this.println("exported: " + libPath);
        }
    }

    private void exportSystemDependencies(String targetModulesFolder, String targetFolder, String targetModuleName, Set<String> systemDependencies) {
        Path targetLibFolder = Paths.get(targetModulesFolder, targetFolder, targetModuleName, "lib");
        for (String dependency : systemDependencies) {
            Path dependencyPath = Paths.get(dependency, new String[0]);
            if (Files.exists(dependencyPath, new LinkOption[0])) {
                Path target = Paths.get(targetLibFolder.toString(), dependencyPath.getFileName().toString());
                new PathFileProxy(dependencyPath).copyTo(target);
                this.println("exported: " + dependencyPath);
                continue;
            }
            this.println("not found: " + dependencyPath);
        }
    }

    private void zipModules(String targetModulesFolder, String projectName, String version) throws IOException {
        File outputZipFile = Paths.get(new File(targetModulesFolder).getParent(), projectName + "-" + version + ".zip").toFile();
        ZipDirectory.builder().dirToZip(new File(targetModulesFolder)).outputZipFile(outputZipFile).build().zip();
        System.out.println("completed zip to file: " + outputZipFile);
    }

    private File findArtifacts(String module, String version) {
        File answer = null;
        String moduleFolder = FileNameProxy.getModuleFolderName(module);
        File targetFolder = (module != null ? Paths.get(module, "target") : Paths.get("target", new String[0])).toFile();
        if (targetFolder.exists()) {
            answer = Paths.get(targetFolder.toString(), moduleFolder + "-" + version + "-bin", "lib").toFile();
            if (!answer.exists()) {
                answer = Paths.get(targetFolder.toString(), moduleFolder + "-" + version + ".jar").toFile();
            }
            if (!answer.exists()) {
                answer = null;
            }
        }
        return answer;
    }

    private static class ExportModuleResult {
        private final String projectName;
        private final String module;
        private final String version;
        private final BuildTool buildTool;

        @Generated
        ExportModuleResult(String projectName, String module, String version, BuildTool buildTool) {
            this.projectName = projectName;
            this.module = module;
            this.version = version;
            this.buildTool = buildTool;
        }

        @Generated
        public static ExportModuleResultBuilder builder() {
            return new ExportModuleResultBuilder();
        }

        @Generated
        public static class ExportModuleResultBuilder {
            @Generated
            private String projectName;
            @Generated
            private String module;
            @Generated
            private String version;
            @Generated
            private BuildTool buildTool;

            @Generated
            ExportModuleResultBuilder() {
            }

            @Generated
            public ExportModuleResultBuilder projectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            @Generated
            public ExportModuleResultBuilder module(String module) {
                this.module = module;
                return this;
            }

            @Generated
            public ExportModuleResultBuilder version(String version) {
                this.version = version;
                return this;
            }

            @Generated
            public ExportModuleResultBuilder buildTool(BuildTool buildTool) {
                this.buildTool = buildTool;
                return this;
            }

            @Generated
            public ExportModuleResult build() {
                return new ExportModuleResult(this.projectName, this.module, this.version, this.buildTool);
            }

            @Generated
            public String toString() {
                return "PackCommandHandler.ExportModuleResult.ExportModuleResultBuilder(projectName=" + this.projectName + ", module=" + this.module + ", version=" + this.version + ", buildTool=" + (Object)((Object)this.buildTool) + ")";
            }
        }
    }
}

