/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import com.tvd12.ezyfox.io.EzyCollections;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyReturner;
import com.tvd12.properties.file.reader.BaseFileReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.youngmonkeys.ezyplatform.sdk.tools.constant.SdkConstants;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.exception.HandleCommandFailedException;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ProjectDependenciesLinker;
import org.youngmonkeys.ezyplatform.sdk.tools.io.XmlReader;

public class MavenProjectDependenciesLinker
implements ProjectDependenciesLinker {
    @Override
    public void link(String projectFolder, String linkProjectName, Set<ModuleType> moduleTypes) throws Exception {
        Path projectPomFilePath = Paths.get(projectFolder, "pom.xml");
        if (!Files.exists(projectPomFilePath, new LinkOption[0])) {
            throw new HandleCommandFailedException("invalid project location, a maven project must have a pom.xml file");
        }
        String projectPomFile = projectPomFilePath.toString();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document projectPomDocument = builder.parse(projectPomFile);
        Map<ModuleType, Map<String, String>> pomFileMap = FileProxy.getInclusivePomFileMap(projectFolder, moduleTypes);
        String ezyplatformHome = FileProxy.getEzyPlatformHome();
        Document dependenciesDocument = this.readDependenciesFile(ezyplatformHome, linkProjectName, builder);
        List<Node> propertyNodes = XmlReader.getChildrenOfElement(dependenciesDocument, "properties");
        List<Element> linkCommonDependencyElements = this.getLinkCommonDependencyElements(dependenciesDocument);
        if (propertyNodes.size() > 0 || linkCommonDependencyElements.size() > 0) {
            this.addPropertyNodes(propertyNodes, projectPomDocument);
            this.addDependencyElements(linkCommonDependencyElements, projectPomDocument);
            XmlReader.writeToFile(projectPomDocument, projectPomFile);
        }
        Map<ModuleType, List<Element>> linkModuleDependencyElementsMap = this.getLinkModuleDependencyElementsMap(dependenciesDocument, moduleTypes);
        Map modulePomDocumentMap = EzyMaps.newHashMapNewValues(pomFileMap, pomFiles -> EzyMaps.newHashMapNewValues((Map)pomFiles, pomFile -> (Document)EzyReturner.returnWithException(() -> builder.parse((String)pomFile))));
        this.addModuleDependencyElements(ezyplatformHome, linkProjectName, pomFileMap, linkModuleDependencyElementsMap, modulePomDocumentMap);
    }

    private void addModuleDependencyElements(String ezyplatformHome, String linkProjectName, Map<ModuleType, Map<String, String>> pomFileMap, Map<ModuleType, List<Element>> linkModuleDependencyElementsMap, Map<ModuleType, Map<String, Document>> modulePomDocumentMap) throws Exception {
        Iterator<ModuleType> iterator = pomFileMap.keySet().iterator();
        while (iterator.hasNext()) {
            ModuleType moduleType;
            ModuleType dependenciesModuleType = moduleType = iterator.next();
            if (moduleType == ModuleType.THEME) {
                dependenciesModuleType = ModuleType.WEB_PLUGIN;
            }
            List<Element> elements = linkModuleDependencyElementsMap.get((Object)dependenciesModuleType);
            Path resourcesFolderPath = Paths.get(ezyplatformHome, dependenciesModuleType.getTargetFolder(), linkProjectName);
            if (EzyCollections.isEmpty(elements) && !Files.exists(resourcesFolderPath, new LinkOption[0])) continue;
            Map<String, Document> pomDocuments = modulePomDocumentMap.get((Object)moduleType);
            for (String moduleFolder : pomDocuments.keySet()) {
                Document pomDocument = pomDocuments.get(moduleFolder);
                if (!EzyCollections.isEmpty(elements)) {
                    this.addDependencyElements(elements, pomDocument);
                }
                if (Files.exists(resourcesFolderPath, new LinkOption[0])) {
                    this.addResourcesDirectoryToPom(linkProjectName, dependenciesModuleType, pomDocument);
                }
                XmlReader.writeToFile(pomDocument, pomFileMap.get((Object)moduleType).get(moduleFolder));
                this.addPackageNameToTestStartupClass(ezyplatformHome, linkProjectName, moduleType, moduleFolder);
            }
        }
    }

    private void addResourcesDirectoryToPom(String projectName, ModuleType moduleType, Document pomDocument) {
        Element resourcesElement;
        Element buildElement;
        Element profileElement;
        Element profilesElement = (Element)XmlReader.getFirstChildOfElement(pomDocument, "profiles");
        if (profilesElement == null) {
            profilesElement = pomDocument.createElement("profiles");
            pomDocument.appendChild(profilesElement);
        }
        if ((profileElement = (Element)XmlReader.getFirstChildOfElement(profilesElement, "profile")) == null) {
            profileElement = pomDocument.createElement("profile");
            profilesElement.appendChild(profileElement);
        }
        if ((buildElement = (Element)XmlReader.getFirstChildOfElement(profileElement, "build")) == null) {
            buildElement = pomDocument.createElement("build");
            profileElement.appendChild(buildElement);
        }
        if ((resourcesElement = (Element)XmlReader.getFirstChildOfElement(buildElement, "resources")) == null) {
            resourcesElement = pomDocument.createElement("resources");
            buildElement.appendChild(resourcesElement);
        }
        String resourcePath = "${ezyplatform.home}/" + moduleType.getTargetFolder() + "/" + projectName + "/resources";
        NodeList resourceNodeList = resourcesElement.getElementsByTagName("resource");
        for (int i = 0; i < resourceNodeList.getLength(); ++i) {
            String textContent = resourceNodeList.item(i).getTextContent().trim();
            if (!textContent.equalsIgnoreCase(resourcePath)) continue;
            return;
        }
        Element resourceElement = pomDocument.createElement("resource");
        resourcesElement.appendChild(resourceElement);
        Element directoryElement = pomDocument.createElement("directory");
        directoryElement.setTextContent(resourcePath);
        resourceElement.appendChild(directoryElement);
    }

    private void addDependencyElements(List<Element> dependencyElements, Document pomDocument) {
        String key;
        String artifactId;
        String groupId;
        Element dependenciesElement = (Element)XmlReader.getFirstChildOfElement(pomDocument, "dependencies");
        if (dependenciesElement == null) {
            dependenciesElement = pomDocument.createElement("dependencies");
            pomDocument.getDocumentElement().appendChild(dependenciesElement);
        }
        List<Element> currentDependencyElements = XmlReader.getChildrenOfElement(pomDocument, "dependencies", "dependency");
        HashMap<String, Element> currentDependencyElementMap = new HashMap<String, Element>();
        for (Element dependencyElement : currentDependencyElements) {
            groupId = XmlReader.getElementTextContent(dependencyElement, "groupId");
            artifactId = XmlReader.getElementTextContent(dependencyElement, "artifactId");
            key = groupId + ":" + artifactId;
            currentDependencyElementMap.putIfAbsent(key, dependencyElement);
        }
        for (Element dependencyElement : dependencyElements) {
            groupId = XmlReader.getElementTextContent(dependencyElement, "groupId");
            artifactId = XmlReader.getElementTextContent(dependencyElement, "artifactId");
            key = groupId + ":" + artifactId;
            if (currentDependencyElementMap.containsKey(key)) continue;
            Element element = (Element)pomDocument.importNode(dependencyElement, true);
            dependenciesElement.appendChild(element);
        }
    }

    private void addPackageNameToTestStartupClass(String ezyplatformHome, String linkProjectName, ModuleType inputModuleType, String moduleFolder) throws Exception {
        ModuleType moduleType = inputModuleType == ModuleType.THEME ? ModuleType.WEB_PLUGIN : inputModuleType;
        File linkModulePropertiesFile = Paths.get(ezyplatformHome, moduleType.getTargetFolder(), linkProjectName, "module.properties").toFile();
        if (!linkModulePropertiesFile.exists()) {
            return;
        }
        Properties linkModuleProperties = new BaseFileReader().read(linkModulePropertiesFile);
        String linkPackageName = linkModuleProperties.getProperty("package");
        if (EzyStrings.isBlank((String)linkPackageName)) {
            throw new HandleCommandFailedException("missing 'package' property in file: " + linkModulePropertiesFile);
        }
        File modulePropertiesFile = Paths.get(moduleFolder, "module.properties").toFile();
        if (!modulePropertiesFile.exists()) {
            return;
        }
        Properties moduleProperties = new BaseFileReader().read(modulePropertiesFile);
        String packageName = moduleProperties.getProperty("package");
        if (EzyStrings.isBlank((String)packageName)) {
            throw new HandleCommandFailedException("missing 'package' property in file: " + modulePropertiesFile);
        }
        String fullPackageName = packageName + "." + SdkConstants.MODULE_SUB_PACKAGES.get((Object)moduleType);
        String startupFileName = EzyStrings.toDisplayName((String)moduleFolder).replace(" ", "") + "StartupTest.java";
        Path startUpFile = Paths.get(moduleFolder, "src/test/java", fullPackageName.replace('.', '/'), "test", startupFileName);
        if (!Files.exists(startUpFile, new LinkOption[0])) {
            return;
        }
        ArrayList newLines = new ArrayList();
        AtomicInteger checkCount = new AtomicInteger();
        AtomicBoolean contains = new AtomicBoolean();
        try (Stream<String> lines = Files.lines(startUpFile);){
            lines.forEach(line -> {
                int ck = checkCount.get();
                if (ck == 0 && line.contains("@ComponentsScan({")) {
                    checkCount.incrementAndGet();
                } else if (ck == 1) {
                    if (line.contains(linkPackageName)) {
                        contains.set(true);
                    } else if (line.contains("})")) {
                        checkCount.incrementAndGet();
                        if (!contains.get()) {
                            int size = newLines.size();
                            if (size > 0) {
                                newLines.set(size - 1, (String)newLines.get(size - 1) + ",");
                            }
                            newLines.add("    \"" + linkPackageName + "\"");
                        }
                    }
                }
                newLines.add(line);
            });
        }
        Files.write(startUpFile, newLines, new OpenOption[0]);
    }

    private List<Element> getLinkCommonDependencyElements(Document dependenciesDocument) {
        return XmlReader.getChildrenOfElement(dependenciesDocument, "common", "dependency");
    }

    private Map<ModuleType, List<Element>> getLinkModuleDependencyElementsMap(Document dependenciesDocument, Set<ModuleType> moduleTypes) {
        HashMap<ModuleType, List<Element>> answer = new HashMap<ModuleType, List<Element>>();
        for (ModuleType moduleType : moduleTypes) {
            answer.put(moduleType, XmlReader.getChildrenOfElement(dependenciesDocument, moduleType.getName(), "dependency"));
        }
        return answer;
    }

    private void addPropertyNodes(List<Node> propertyNodes, Document projectPomDocument) {
        Element propertiesElement = (Element)XmlReader.getFirstChildOfElement(projectPomDocument, "properties");
        if (propertiesElement == null) {
            propertiesElement = projectPomDocument.createElement("properties");
            projectPomDocument.appendChild(propertiesElement);
        }
        for (Node propertyNode : propertyNodes) {
            if (propertyNode.getNodeType() != 1 || propertiesElement.getElementsByTagName(propertyNode.getNodeName()).getLength() != 0) continue;
            Node node = projectPomDocument.importNode(propertyNode, true);
            propertiesElement.appendChild(node);
        }
    }

    private Document readDependenciesFile(String ezyplatformHome, String linkProjectName, DocumentBuilder documentBuilder) throws Exception {
        if (EzyStrings.isBlank((String)ezyplatformHome)) {
            throw new HandleCommandFailedException("you need setup EZYPLATFORM_HOME first");
        }
        for (ModuleType moduleType : ModuleType.values()) {
            Path filePath = Paths.get(ezyplatformHome, moduleType.getTargetFolder(), linkProjectName, "dependencies.xml");
            if (!Files.exists(filePath, new LinkOption[0])) continue;
            return documentBuilder.parse(filePath.toString());
        }
        throw new HandleCommandFailedException("project " + linkProjectName + " has no dependencies.xml file");
    }
}

