/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.youngmonkeys.ezyplatform.sdk.tools.extractor.LibExtractor;
import org.youngmonkeys.ezyplatform.sdk.tools.io.PathFileProxy;

public class PathFolderProxy {
    private final Path path;

    public static void createFolder(Path folder) {
        if (folder != null && !Files.exists(folder, new LinkOption[0])) {
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                System.err.println("Can not create directory: " + folder + ", please check your permission");
                throw new IllegalStateException(e);
            }
        }
    }

    public void copyTo(String targetFolder, Predicate<Path> filter, Consumer<Path> copiedCallback) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(this.path, new FileVisitOption[0]);){
            stream.filter(filter).forEach(filePath -> {
                String targetFilePath = filePath.toString().replace(this.path.toString(), targetFolder);
                Path toPath = Paths.get(targetFilePath, new String[0]);
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    new PathFileProxy((Path)filePath).copyTo(toPath);
                    copiedCallback.accept((Path)filePath);
                } else {
                    PathFolderProxy.createFolder(toPath);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not copy folder: " + this.path + " to " + targetFolder + ", please check your permission", e);
        }
    }

    public Set<String> getJavaLibOnlyNames() {
        return this.getJavaLibNames().keySet().stream().map(LibExtractor::extractLibName).collect(Collectors.toSet());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Path> getJavaLibNames() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try (Stream<Path> stream = Files.walk(this.path, new FileVisitOption[0]);){
            Map<String, Path> map = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(it -> it.getFileName().toString().endsWith(".jar")).collect(Collectors.toMap(it -> it.getFileName().toString(), it -> it));
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("can not get java libs in " + this.path + ": " + e.getMessage() + ", please check your permission");
            throw new IllegalStateException(e);
        }
    }

    @Generated
    public PathFolderProxy(Path path) {
        this.path = path;
    }
}

