/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import com.tvd12.ezyfox.io.EzyStrings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.youngmonkeys.ezyplatform.sdk.tools.constant.SdkConstants;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.XmlReader;

public final class PomXmlReaders {
    private PomXmlReaders() {
    }

    public static String getCurrentVersion(String versionLine) {
        String openTag = SdkConstants.wrapOpenXmlTagName("version");
        String closeTag = SdkConstants.wrapCloseXmlTagName("version");
        int startIndex = versionLine.indexOf(openTag);
        startIndex = startIndex >= 0 ? (startIndex += openTag.length()) : versionLine.indexOf(62) + 1;
        int endIndex = versionLine.indexOf(closeTag);
        if (endIndex < 0) {
            endIndex = versionLine.indexOf("</");
        }
        return versionLine.substring(startIndex, endIndex).trim();
    }

    public static String getProjectVersionFromPomOrThrow(File projectFolder) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return PomXmlReaders.getProjectVersionFromPomOrThrow(projectFolder, builder);
    }

    public static String getProjectVersionFromPomOrThrow(File projectFolder, DocumentBuilder documentBuilder) throws Exception {
        Node parentElement;
        Path pomFile = FileProxy.getProjectPomFileOrThrow(projectFolder.toString());
        Document projectPomDocument = documentBuilder.parse(pomFile.toFile());
        Node versionElement = XmlReader.getFirstChildOfElement(projectPomDocument, "version");
        String version = null;
        if (versionElement != null) {
            version = versionElement.getTextContent();
        }
        if (version == null && (parentElement = XmlReader.getFirstChildOfElement(projectPomDocument, "parent")) != null && (versionElement = XmlReader.getFirstChildOfElement(projectPomDocument, "version")) != null) {
            version = versionElement.getTextContent();
        }
        if (EzyStrings.isBlank((String)version)) {
            throw new IllegalArgumentException("has not set version for: " + projectFolder);
        }
        return version;
    }

    public static String getProjectGroupIdOrThrow(File projectFolder, DocumentBuilder documentBuilder) throws Exception {
        Path pomFilePath = Paths.get(projectFolder.toString(), "pom.xml");
        if (Files.exists(pomFilePath, new LinkOption[0])) {
            Document document = documentBuilder.parse(pomFilePath.toString());
            Node groupIdNode = XmlReader.getFirstChildOfElement(document, "groupId");
            if (groupIdNode == null) {
                groupIdNode = XmlReader.getFirstChildOfElement(document, "parent", "groupId");
            }
            if (groupIdNode != null) {
                return groupIdNode.getTextContent();
            }
            throw new IllegalArgumentException("invalid pom file: " + pomFilePath);
        }
        throw new IllegalArgumentException("maven project must have a pom.xml file");
    }

    public static String getProjectArtifactIdOrThrow(File pomFilePath) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(pomFilePath.toString());
        Node artifactIdNode = XmlReader.getFirstChildOfElement(document, "artifactId");
        if (artifactIdNode != null) {
            return artifactIdNode.getTextContent();
        }
        throw new IllegalArgumentException("invalid pom file: " + pomFilePath);
    }
}

