/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.io;

import com.tvd12.ezyfox.io.EzyByteBuffers;
import java.nio.ByteBuffer;

public final class EzyBytes {
    private EzyBytes() {
    }

    public static byte[] copy(ByteBuffer buffer, int size) {
        return EzyByteBuffers.getBytes(buffer, size);
    }

    public static byte[] copy(byte[] bytes, int offset, int length) {
        byte[] answer = new byte[length];
        System.arraycopy(bytes, offset, answer, 0, length);
        return answer;
    }

    public static byte[] getBytes(ByteBuffer buffer) {
        return EzyByteBuffers.getBytes(buffer);
    }

    public static byte[] getBytes(int first, int value, int size) {
        return EzyBytes.getBytes(first, (long)value, size);
    }

    public static byte[] getBytes(int first, long value, int size) {
        return EzyBytes.getBytes((byte)first, value, size);
    }

    public static byte[] getBytes(byte first, long value, int size) {
        return EzyBytes.merge(first, EzyBytes.getBytes(value, size));
    }

    public static byte[] getBytes(byte first, double value) {
        return EzyBytes.merge(first, EzyBytes.getBytes(value));
    }

    public static byte[] getBytes(byte first, float value) {
        return EzyBytes.merge(first, EzyBytes.getBytes(value));
    }

    public static byte[] getBytes(double value) {
        return EzyBytes.getBytes(Double.doubleToLongBits(value), 8);
    }

    public static byte[] getBytes(float value) {
        return EzyBytes.getBytes(Float.floatToIntBits(value), 4);
    }

    public static byte[] getBytes(long value) {
        return EzyBytes.getBytes(value, 8);
    }

    public static byte[] getBytes(int value) {
        return EzyBytes.getBytes(value, 4);
    }

    public static byte[] getBytes(short value) {
        return EzyBytes.getBytes(value, 2);
    }

    public static byte[] getBytes(long value, int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)(value >> (size - i - 1) * 8 & 0xFFL);
        }
        return bytes;
    }

    public static byte[] merge(byte first, byte[] other) {
        byte[] bytes = new byte[other.length + 1];
        bytes[0] = first;
        System.arraycopy(other, 0, bytes, 1, other.length);
        return bytes;
    }

    public static byte[] merge(byte[][] byteArrays) {
        int position = 0;
        byte[] answer = new byte[EzyBytes.totalBytes(byteArrays)];
        for (byte[] bytes : byteArrays) {
            System.arraycopy(bytes, 0, answer, position, bytes.length);
            position += bytes.length;
        }
        return answer;
    }

    public static int totalBytes(byte[][] byteArrays) {
        int size = 0;
        for (byte[] bytes : byteArrays) {
            size += bytes.length;
        }
        return size;
    }

    public static byte[] numberToBytes(long number) {
        if (number >= 0L) {
            if (number <= 127L) {
                return new byte[]{(byte)number};
            }
            if (number <= 32767L) {
                return EzyBytes.getBytes((short)number);
            }
            if (number <= Integer.MAX_VALUE) {
                return EzyBytes.getBytes((int)number);
            }
            return EzyBytes.getBytes(number);
        }
        if (number < Integer.MIN_VALUE) {
            return EzyBytes.getBytes(number);
        }
        if (number < -32768L) {
            return EzyBytes.getBytes((int)number);
        }
        if (number < -128L) {
            return EzyBytes.getBytes((short)number);
        }
        return new byte[]{(byte)number};
    }

    public static int[] toIntArray(byte[] bytes) {
        int[] answer = new int[bytes.length];
        ByteBuffer buffer = ByteBuffer.allocate(4);
        for (int i = 0; i < bytes.length; ++i) {
            buffer.clear();
            buffer.put(new byte[]{0, 0, 0, bytes[i]});
            buffer.flip();
            answer[i] = buffer.getInt();
        }
        return answer;
    }
}

