/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class EzyMapFactory {
    protected final Map<Class, Supplier<Map>> suppliers = this.defaultSuppliers();

    public <T extends Map> T newMap(Class mapType) {
        if (this.suppliers.containsKey(mapType)) {
            return (T)this.suppliers.get(mapType).get();
        }
        throw new IllegalArgumentException("unknown implementation of " + mapType);
    }

    private Map<Class, Supplier<Map>> defaultSuppliers() {
        ConcurrentHashMap<Class, Supplier<Map>> map = new ConcurrentHashMap<Class, Supplier<Map>>();
        map.put(Map.class, HashMap::new);
        map.put(HashMap.class, HashMap::new);
        map.put(TreeMap.class, TreeMap::new);
        map.put(ConcurrentHashMap.class, ConcurrentHashMap::new);
        return map;
    }
}

