/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;

public class ZipDirectory {
    private final File dirToZip;
    private final File outputZipFile;

    public void zip() throws IOException {
        LinkedList<File> queue = new LinkedList<File>();
        queue.offer(this.dirToZip);
        byte[] buffer = new byte[1024];
        ZipOutputStream zipOut = new ZipOutputStream(Files.newOutputStream(this.outputZipFile.toPath(), new OpenOption[0]));
        String dirToZipParent = this.dirToZip.getParent();
        while (!queue.isEmpty()) {
            File fileOrFolder = (File)queue.poll();
            if (fileOrFolder.isHidden()) {
                System.out.println("ignore: " + fileOrFolder);
                continue;
            }
            if (fileOrFolder.isDirectory()) {
                String folderPath;
                File[] listFiles = fileOrFolder.listFiles();
                if (listFiles != null) {
                    for (File file : listFiles) {
                        if (file.equals(this.outputZipFile)) continue;
                        queue.offer(file);
                    }
                }
                if ((folderPath = this.getPathInOutputZip(fileOrFolder.toString(), dirToZipParent)).endsWith("/")) {
                    zipOut.putNextEntry(this.newZipEntry(folderPath));
                    zipOut.closeEntry();
                } else {
                    zipOut.putNextEntry(this.newZipEntry(folderPath + "/"));
                    zipOut.closeEntry();
                }
            } else {
                this.appendFileToZip(zipOut, fileOrFolder, dirToZipParent, buffer);
            }
            System.out.println("zip: " + fileOrFolder);
        }
        zipOut.close();
    }

    private void appendFileToZip(ZipOutputStream zipOut, File fileToAppend, String dirToZipParent, byte[] buffer) throws IOException {
        int length;
        FileInputStream inputStream = new FileInputStream(fileToAppend);
        ZipEntry zipEntry = this.newZipEntry(this.getPathInOutputZip(fileToAppend.toString(), dirToZipParent));
        zipOut.putNextEntry(zipEntry);
        while ((length = inputStream.read(buffer)) >= 0) {
            zipOut.write(buffer, 0, length);
        }
        zipOut.closeEntry();
        inputStream.close();
    }

    private ZipEntry newZipEntry(String name) {
        return new ZipEntry(name.replace('\\', '/'));
    }

    private String getPathInOutputZip(String fullFilePath, String dirToZipParent) {
        int index = fullFilePath.indexOf(dirToZipParent);
        return index < 0 ? fullFilePath : fullFilePath.substring(index + dirToZipParent.length());
    }

    @Generated
    ZipDirectory(File dirToZip, File outputZipFile) {
        this.dirToZip = dirToZip;
        this.outputZipFile = outputZipFile;
    }

    @Generated
    public static ZipDirectoryBuilder builder() {
        return new ZipDirectoryBuilder();
    }

    @Generated
    public static class ZipDirectoryBuilder {
        @Generated
        private File dirToZip;
        @Generated
        private File outputZipFile;

        @Generated
        ZipDirectoryBuilder() {
        }

        @Generated
        public ZipDirectoryBuilder dirToZip(File dirToZip) {
            this.dirToZip = dirToZip;
            return this;
        }

        @Generated
        public ZipDirectoryBuilder outputZipFile(File outputZipFile) {
            this.outputZipFile = outputZipFile;
            return this;
        }

        @Generated
        public ZipDirectory build() {
            return new ZipDirectory(this.dirToZip, this.outputZipFile);
        }

        @Generated
        public String toString() {
            return "ZipDirectory.ZipDirectoryBuilder(dirToZip=" + this.dirToZip + ", outputZipFile=" + this.outputZipFile + ")";
        }
    }
}

