/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.util;

import com.tvd12.properties.file.exception.PropertiesFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public final class InputStreamUtil {
    private InputStreamUtil() {
    }

    public static InputStream getInputStream(ClassLoader classLoader, String filePath) {
        InputStream inputStream = InputStreamUtil.getResourceAsStream(classLoader, filePath);
        if (inputStream == null) {
            inputStream = InputStreamUtil.getResourceAsStream(classLoader, "/" + filePath);
        }
        if (inputStream == null) {
            inputStream = InputStreamUtil.getInputStreamByAbsolutePath(filePath);
        }
        if (inputStream == null) {
            throw new PropertiesFileException("Can not read file in path " + filePath + ", maybe it's not found");
        }
        return inputStream;
    }

    private static InputStream getResourceAsStream(ClassLoader classLoader, String filePath) {
        InputStream ip;
        ClassLoader acceptClassLoader = classLoader;
        if (acceptClassLoader == null) {
            acceptClassLoader = InputStreamUtil.getDefaultClassLoader();
        }
        if ((ip = acceptClassLoader.getResourceAsStream(filePath)) == null) {
            ip = ClassLoader.getSystemResourceAsStream(filePath);
        }
        if (ip == null) {
            ip = InputStreamUtil.getResourceAsStreamInOthers(acceptClassLoader, filePath);
        }
        return ip;
    }

    private static InputStream getResourceAsStreamInOthers(ClassLoader classLoader, String resource) {
        ArrayList<URL> resourcesUrls = new ArrayList<URL>();
        try {
            InputStreamUtil.addResourceUrls(resourcesUrls, () -> classLoader.getResources(resource));
            InputStreamUtil.addResourceUrls(resourcesUrls, () -> ClassLoader.getSystemResources(resource));
            InputStreamUtil.addResourceUrl(resourcesUrls, classLoader.getResource(resource));
            InputStreamUtil.addResourceUrl(resourcesUrls, ClassLoader.getSystemResource(resource));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return resourcesUrls.isEmpty() ? null : ((URL)resourcesUrls.get(0)).openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void addResourceUrls(List<URL> resourcesUrls, UrlsSupplier supplier) {
        try {
            Enumeration<URL> urls = supplier.get();
            InputStreamUtil.addResourceUrls(resourcesUrls, urls);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addResourceUrls(List<URL> resourcesUrls, Enumeration<URL> urls) {
        if (urls != null) {
            while (urls.hasMoreElements()) {
                resourcesUrls.add(urls.nextElement());
            }
        }
    }

    private static void addResourceUrl(List<URL> resourcesUrls, URL url) {
        if (url != null) {
            resourcesUrls.add(url);
        }
    }

    private static InputStream getInputStreamByAbsolutePath(String filePath) {
        return InputStreamUtil.getInputStreamByAbsolutePath(new File(filePath));
    }

    public static InputStream getInputStreamByAbsolutePath(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int nbyte;
        int readBytes = 0;
        byte[] buffer = new byte[128];
        while ((nbyte = input.read()) != -1) {
            buffer[readBytes++] = (byte)nbyte;
            if (readBytes < buffer.length) continue;
            byte[] newBuffer = new byte[buffer.length + 128];
            System.arraycopy(buffer, 0, newBuffer, 0, readBytes);
            buffer = newBuffer;
        }
        byte[] answer = new byte[readBytes];
        System.arraycopy(buffer, 0, answer, 0, readBytes);
        return answer;
    }

    public static String guessContentType(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            return "properties";
        }
        int maxRead = 255;
        inputStream.mark(maxRead);
        int i = 0;
        String contenType = "properties";
        try {
            int b;
            while (i++ < maxRead && (b = inputStream.read()) != -1 && b != 61) {
                if (b != 58) continue;
                contenType = "yaml";
                break;
            }
            inputStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return contenType;
    }

    private static interface UrlsSupplier {
        public Enumeration<URL> get() throws IOException;
    }
}

