/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.handler;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyDirectories;
import com.tvd12.ezyfox.util.EzyFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.youngmonkeys.ezyplatform.sdk.tools.arguments.CreateProjectArguments;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleType;
import org.youngmonkeys.ezyplatform.sdk.tools.handler.AbstractCommandHandler;

public class CreateProjectCommandHandler
extends AbstractCommandHandler<CreateProjectArguments> {
    @Override
    public String handle(CreateProjectArguments args) {
        Path outputProjectPath;
        String sdkHome = System.getenv("EZYPLATFORM_SDK");
        if (EzyStrings.isBlank((String)sdkHome)) {
            sdkHome = System.getProperty("EZYPLATFORM_SDK");
        }
        if (EzyStrings.isBlank((String)sdkHome)) {
            throw new IllegalStateException("you need setup EZYPLATFORM_SDKfirst");
        }
        Path templatePath = Paths.get(sdkHome, "templates", "project-template");
        Path path = outputProjectPath = EzyStrings.isBlank((String)args.getOutputDirectory()) ? Paths.get(args.getProjectName(), new String[0]) : Paths.get(args.getOutputDirectory(), args.getProjectName());
        if (Files.exists(outputProjectPath, new LinkOption[0])) {
            System.out.print("Folder " + outputProjectPath + " existed, do you want to override? (yes): ");
            String answer = new Scanner(System.in).nextLine();
            if (!answer.equalsIgnoreCase("yes")) {
                return "Cancelled!";
            }
        }
        HashMap<String, String> variableValues = new HashMap<String, String>();
        variableValues.put("${groupId}", args.getGroupName());
        variableValues.put("${groupName}", args.getGroupName());
        variableValues.put("${projectName}", args.getProjectName());
        variableValues.put("${projectDisplayName}", args.getProjectDisplayName());
        variableValues.put("${projectNameUnderscoreCase}", args.getProjectNameUnderscoreCase());
        variableValues.put("${package}", args.getPackageName());
        variableValues.put("${packageName}", args.getPackageName());
        variableValues.put("${version}", args.getVersion());
        variableValues.put("${versionName}", args.getVersion());
        variableValues.put("${symbol_pound}", "#");
        variableValues.put("${symbol_dollar}", "$");
        variableValues.put("${symbol_escape}", "\\");
        variableValues.put("${rootArtifactId}", args.getProjectName());
        variableValues.put("${parentArtifactId}", args.getProjectName());
        variableValues.put("${projectNameUpperCase}", args.getProjectUpperCase());
        variableValues.put("${author}", args.getAuthor());
        variableValues.put("${projectAuthor}", args.getAuthor());
        variableValues.put("__rootArtifactId__", args.getProjectName());
        variableValues.put("__parentArtifactId__", args.getProjectName());
        variableValues.put("__projectNameUpperCase__", args.getProjectUpperCase());
        this.generateProject(templatePath, outputProjectPath, args.getPackageName(), args.getModuleTypes(), variableValues);
        return "Completed, project dir: " + outputProjectPath;
    }

    private void generateProject(Path templatePath, Path outputProjectPath, String packageName, Set<ModuleType> moduleTypes, Map<String, String> variableValues) {
        Path parentPomTemplate = templatePath.resolve("pom.xml");
        Path exportShFileTemplate = templatePath.resolve("export.sh");
        Path exportBatFileTemplate = templatePath.resolve("export.bat");
        List exclusiveParentPaths = Stream.of(ModuleType.values()).filter(it -> !moduleTypes.contains(it)).map(it -> templatePath.resolve("__rootArtifactId__-" + it.getName())).collect(Collectors.toList());
        if (moduleTypes.size() <= 1) {
            exclusiveParentPaths.add(templatePath.resolve("__rootArtifactId__-sdk"));
        }
        try (Stream<Path> paths = Files.walk(templatePath, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(it -> !it.toString().endsWith(".DS_Store")).forEach(path -> {
                if (path.equals(parentPomTemplate)) {
                    this.generateParentPom(parentPomTemplate, outputProjectPath, moduleTypes, variableValues);
                } else if (path.endsWith(exportShFileTemplate)) {
                    this.generateExportFile(exportShFileTemplate, false, outputProjectPath, "export.sh", moduleTypes, variableValues);
                } else if (path.endsWith(exportBatFileTemplate)) {
                    this.generateExportFile(exportBatFileTemplate, true, outputProjectPath, "export.bat", moduleTypes, variableValues);
                } else {
                    for (Path exclusiveParentPath : exclusiveParentPaths) {
                        if (!path.startsWith(exclusiveParentPath)) continue;
                        return;
                    }
                    this.generateNormalFiles(templatePath, (Path)path, outputProjectPath, packageName, moduleTypes.size() > 1, moduleTypes.contains((Object)ModuleType.WEB_PLUGIN), moduleTypes.contains((Object)ModuleType.SOCKET_PLUGIN), variableValues);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath, e);
        }
    }

    private void generateParentPom(Path parentPomTemplate, Path outputProjectPath, Set<ModuleType> moduleTypes, Map<String, String> variableValues) {
        List<String> content;
        Set<String> exclusiveLines = Stream.of(ModuleType.values()).filter(it -> !moduleTypes.contains(it)).map(it -> "<module>${projectName}-" + it.getName() + "</module>").collect(Collectors.toSet());
        if (moduleTypes.size() <= 1) {
            exclusiveLines.add("<module>${projectName}-sdk</module>");
        }
        try {
            content = this.generateFileContent(parentPomTemplate, "", moduleTypes.size() > 1, moduleTypes.contains((Object)ModuleType.WEB_PLUGIN), moduleTypes.contains((Object)ModuleType.SOCKET_PLUGIN), exclusiveLines, variableValues);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can not generate file content from: " + parentPomTemplate, e);
        }
        Path outputFilePath = outputProjectPath.resolve("pom.xml");
        try {
            Files.write(outputFilePath, content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can generate file: " + "pom.xml", e);
        }
    }

    private void generateExportFile(Path exportFile, boolean isBatFile, Path outputProjectPath, String outputFile, Set<ModuleType> moduleTypes, Map<String, String> variableValues) {
        List<String> content;
        Set<String> exclusiveLines = Stream.of(ModuleType.values()).filter(it -> !moduleTypes.contains(it)).map(it -> "mvn -pl ${projectName}-" + it.getName() + " clean install -Pexport,\\!test" + (isBatFile ? " & ^" : "")).collect(Collectors.toSet());
        if (moduleTypes.size() <= 1) {
            exclusiveLines.add(isBatFile ? "mvn -pl ${projectName}-sdk clean install & ^" : "mvn -pl ${projectName}-sdk clean install");
        }
        try {
            content = this.generateFileContent(exportFile, "", moduleTypes.size() > 1, moduleTypes.contains((Object)ModuleType.WEB_PLUGIN), moduleTypes.contains((Object)ModuleType.SOCKET_PLUGIN), exclusiveLines, variableValues);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can not generate file content from: " + exportFile, e);
        }
        Path outputFilePath = outputProjectPath.resolve(outputFile);
        try {
            EzyFileUtil.createFileIfNotExists((File)outputFilePath.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can create file: " + outputFilePath, e);
        }
        try {
            Files.write(outputFilePath, content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can generate file: " + outputFile, e);
        }
    }

    private void generateNormalFiles(Path templatePath, Path templateFilePath, Path outputProjectPath, String packageName, boolean includeSdk, boolean includeWebPlugin, boolean includeSocketPlugin, Map<String, String> variableValues) {
        List<String> content;
        String subpath = EzyDirectories.subpath((Path)templateFilePath, (Path)templatePath).toString();
        String actualSubpath = this.isJavaTemplateFilePath(subpath) ? this.insertPackageIntoJavaFilePath(subpath, packageName) : subpath;
        String outputRelativePath = this.setVariable(actualSubpath, "", variableValues);
        String outputFilePath = outputProjectPath.resolve(outputRelativePath).toString();
        String moduleName = Paths.get(outputRelativePath, new String[0]).getName(0).toString();
        if (templateFilePath.toString().endsWith(".png")) {
            try {
                EzyFileUtil.copyFile((File)templateFilePath.toFile(), (File)new File(outputFilePath));
            }
            catch (IOException e) {
                throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can generate file: " + actualSubpath, e);
            }
            return;
        }
        try {
            content = this.generateFileContent(templateFilePath, moduleName, includeSdk, includeWebPlugin, includeSocketPlugin, Collections.emptySet(), variableValues);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can not generate file content from: " + templateFilePath, e);
        }
        try {
            EzyFileUtil.createFileIfNotExists((File)new File(outputFilePath));
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can create file: " + outputFilePath, e);
        }
        try {
            Files.write(Paths.get(outputFilePath, new String[0]), content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not create project: " + outputProjectPath + " cause by can generate file: " + actualSubpath, e);
        }
    }

    private List<String> generateFileContent(Path templateFilePath, String moduleName, boolean includeSdk, boolean includeWebPlugin, boolean includeSocketPlugin, Set<String> exclusiveLines, Map<String, String> variableValues) throws IOException {
        AtomicBoolean validLine = new AtomicBoolean(true);
        try (Stream<String> lines = Files.lines(templateFilePath);){
            List<String> list = lines.filter(line -> {
                String lineTrim = line.trim();
                if (exclusiveLines.contains(lineTrim)) {
                    return false;
                }
                if (!includeSdk && lineTrim.equals("<!-- start add sdk dependency -->") || !includeWebPlugin && lineTrim.equals("<!-- start add web plugin dependency -->") || !includeSocketPlugin && lineTrim.equals("<!-- start add socket plugin dependency -->")) {
                    validLine.set(false);
                } else if (!includeSdk && lineTrim.equals("<!-- end add sdk dependency -->") || !includeWebPlugin && lineTrim.equals("<!-- end add web plugin dependency -->") || !includeSocketPlugin && lineTrim.equals("<!-- end add socket plugin dependency -->")) {
                    validLine.set(true);
                    return false;
                }
                return validLine.get();
            }).map(line -> this.setVariable((String)line, moduleName, variableValues)).collect(Collectors.toList());
            return list;
        }
    }

    private String setVariable(String str, String moduleName, Map<String, String> variableValues) {
        String answer = str;
        for (String variableName : variableValues.keySet()) {
            String variableValue = variableValues.get(variableName);
            if (variableValue == null) {
                throw new IllegalArgumentException(variableName + " can not be null");
            }
            answer = answer.replace(variableName, variableValue);
        }
        return answer.replace("${artifactId}", moduleName);
    }

    private boolean isJavaTemplateFilePath(String filePath) {
        return filePath.contains(Paths.get("src", "main", "java").toString()) || filePath.contains(Paths.get("src", "test", "java").toString());
    }

    private String insertPackageIntoJavaFilePath(String filePath, String packageName) {
        String mainJavaPath = Paths.get("src", "main", "java").toString();
        String testJavaPath = Paths.get("src", "test", "java").toString();
        String javaPath = filePath.contains(mainJavaPath) ? mainJavaPath : testJavaPath;
        int index = filePath.indexOf(javaPath);
        return Paths.get(filePath.substring(0, index), javaPath, packageName.replace('.', '/'), filePath.substring(index + javaPath.length())).toString();
    }

    @Override
    public CreateProjectArguments parse(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("missing project name, run help to see how to create a project");
        }
        String projectName = args[0];
        if (!projectName.matches("[a-zA-Z0-9\\-\\s]{2,60}")) {
            throw new IllegalArgumentException("invalid project name, run help to see how to create a project");
        }
        String groupName = null;
        String packageName = null;
        String version = null;
        String author = null;
        String outputDirectory = null;
        HashSet<ModuleType> inclusiveModuleTypes = new HashSet<ModuleType>();
        HashSet<ModuleType> exclusiveModuleTypes = new HashSet<ModuleType>();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-g") && i < args.length - 1) {
                groupName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-p") && i < args.length - 1) {
                packageName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-v") && i < args.length - 1) {
                version = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-i") && i < args.length - 1) {
                inclusiveModuleTypes.addAll(this.extractModuleType(args[i + 1]));
                ++i;
                continue;
            }
            if (args[i].equals("-e") && i < args.length - 1) {
                exclusiveModuleTypes.addAll(this.extractModuleType(args[i + 1]));
                ++i;
                continue;
            }
            if (args[i].equals("-a") && i < args.length - 1) {
                author = args[i + 1];
                if (++i >= args.length - 1 || args[i + 1].startsWith("-")) continue;
                author = author + " " + args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-o") && i < args.length - 1) {
                outputDirectory = args[i + 1];
                ++i;
                continue;
            }
            throw new IllegalArgumentException("unknown option: " + args[i] + ", run help to see how to create a project");
        }
        if (EzyStrings.isBlank(version)) {
            version = "1.0.0";
        }
        if (inclusiveModuleTypes.isEmpty()) {
            inclusiveModuleTypes.addAll(Arrays.asList(ModuleType.values()));
        }
        if (exclusiveModuleTypes.size() > 0 && exclusiveModuleTypes.containsAll(inclusiveModuleTypes)) {
            throw new IllegalArgumentException("must include at least 1 module type, run help to see how to create a project");
        }
        if (EzyStrings.isNotBlank(packageName) && !packageName.matches("[a-z0-9_.]+")) {
            throw new IllegalArgumentException("invalid package name, run help to see how to create a project");
        }
        if (!version.matches("[0-9]+[.][0-9]+[.][0-9]+")) {
            throw new IllegalArgumentException("invalid version, run help to see how to create a project");
        }
        return CreateProjectArguments.builder().projectName(projectName).groupName(groupName).packageName(packageName).version(version).author(author).outputDirectory(outputDirectory).inclusiveModuleTypes(inclusiveModuleTypes).exclusiveModuleTypes(exclusiveModuleTypes).build();
    }
}

