/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import com.tvd12.properties.file.reader.BaseFileReader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.youngmonkeys.ezyplatform.sdk.tools.data.BuildTool;
import org.youngmonkeys.ezyplatform.sdk.tools.data.LocalProperties;

public class LocalPropertiesReader {
    public LocalProperties read(String module) {
        String ezyplatformHome;
        File localPropertiesFile = this.getLocalPropertiesFile(module);
        Properties localProperties = new BaseFileReader().read(localPropertiesFile);
        String buildToolName = localProperties.getProperty("build.tool");
        BuildTool buildTool = null;
        if (buildToolName != null && (buildTool = BuildTool.of(buildToolName)) == null) {
            throw new IllegalStateException("invalid build tool is null, they must be in maven|gradle|npm|none");
        }
        if (buildTool == null) {
            buildTool = this.detectBuildTool(module);
            System.out.println("build.tool property (maven|gradle|npm|none) not found in local.properties file,  default: " + buildTool.getName());
        }
        if ((ezyplatformHome = localProperties.getProperty("ezy.home")) == null) {
            ezyplatformHome = localProperties.getProperty("ezyplatform.home");
        }
        if (ezyplatformHome == null) {
            throw new IllegalStateException("there is no ezyplatform home in local.properties file, please set ezy.home=<your ezyplatfrom home> or ezyplatform.home=<your ezyplatform home>");
        }
        return LocalProperties.builder().buildTool(buildTool).ezyplatformHome(ezyplatformHome).build();
    }

    private File getLocalPropertiesFile(String module) {
        Path path;
        if (module != null && Files.exists(path = Paths.get(module, "local.properties"), new LinkOption[0])) {
            return path.toFile();
        }
        path = Paths.get("local.properties", new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return path.toFile();
        }
        path = Paths.get("..", "local.properties");
        if (Files.exists(path, new LinkOption[0])) {
            return path.toFile();
        }
        throw new IllegalStateException("local.properties file not found");
    }

    private BuildTool detectBuildTool(String module) {
        if (module != null) {
            if (Files.exists(Paths.get(module, "pom.xml"), new LinkOption[0])) {
                return BuildTool.MAVEN;
            }
            if (Files.exists(Paths.get(module, "build.gradle"), new LinkOption[0])) {
                return BuildTool.GRALDE;
            }
            if (Files.exists(Paths.get(module, "package.json"), new LinkOption[0])) {
                return BuildTool.NPM;
            }
        }
        if (Files.exists(Paths.get("pom.xml", new String[0]), new LinkOption[0])) {
            return BuildTool.MAVEN;
        }
        if (Files.exists(Paths.get("build.gradle", new String[0]), new LinkOption[0])) {
            return BuildTool.GRALDE;
        }
        if (Files.exists(Paths.get("package.json", new String[0]), new LinkOption[0])) {
            return BuildTool.NPM;
        }
        if (Files.exists(Paths.get("../pom.xml", new String[0]), new LinkOption[0])) {
            return BuildTool.MAVEN;
        }
        if (Files.exists(Paths.get("../build.gradle", new String[0]), new LinkOption[0])) {
            return BuildTool.GRALDE;
        }
        if (Files.exists(Paths.get("../package.json", new String[0]), new LinkOption[0])) {
            return BuildTool.NPM;
        }
        return BuildTool.NONE;
    }

    public String getEzyPlatformHome(String module) {
        String answer = System.getenv("EZYPLATFORM_HOME");
        if (answer == null) {
            LocalProperties localProperties = this.read(module);
            answer = localProperties.getEzyplatformHome();
        }
        return answer;
    }
}

