/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.sdk.tools.io;

import com.tvd12.ezyfox.io.EzyStrings;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModuleProperties;
import org.youngmonkeys.ezyplatform.sdk.tools.data.ModulesProperties;
import org.youngmonkeys.ezyplatform.sdk.tools.io.FileNameProxy;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ModulePropertiesReader;
import org.youngmonkeys.ezyplatform.sdk.tools.io.ModulesPropertiesReader;

public final class ProjectNameFetcher {
    private ProjectNameFetcher() {
    }

    public static String getProjectName() {
        File[] moduleFolders;
        String projectName = null;
        ModulesProperties modulesProperties = new ModulesPropertiesReader().read();
        if (modulesProperties != null) {
            projectName = modulesProperties.getProjectName();
        }
        File projectFolder = new File(".");
        if (projectName == null && (moduleFolders = projectFolder.listFiles()) != null) {
            for (File moduleFolder : moduleFolders) {
                ModuleProperties moduleProperties;
                Path modulePropertiesFile;
                if (!moduleFolder.isFile() && Files.exists(modulePropertiesFile = moduleFolder.toPath().resolve("module.properties"), new LinkOption[0]) && (projectName = (moduleProperties = new ModulePropertiesReader().read(moduleFolder.toString())).getProjectName()) != null) break;
            }
        }
        if (projectName == null) {
            projectName = FileNameProxy.extractFileName(projectFolder.toString());
        }
        return EzyStrings.toDashCase((String)projectName.toLowerCase().replace(' ', '-'));
    }
}

