/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.converter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import org.youngmonkeys.ezyplatform.entity.Admin;
import org.youngmonkeys.ezyplatform.entity.AdminAccessToken;
import org.youngmonkeys.ezyplatform.entity.AdminRole;
import org.youngmonkeys.ezyplatform.entity.ContentTemplate;
import org.youngmonkeys.ezyplatform.entity.DataMapping;
import org.youngmonkeys.ezyplatform.entity.Letter;
import org.youngmonkeys.ezyplatform.entity.LetterReceiver;
import org.youngmonkeys.ezyplatform.entity.Link;
import org.youngmonkeys.ezyplatform.entity.Media;
import org.youngmonkeys.ezyplatform.entity.Notification;
import org.youngmonkeys.ezyplatform.entity.NotificationReceiver;
import org.youngmonkeys.ezyplatform.entity.User;
import org.youngmonkeys.ezyplatform.entity.UserAccessToken;
import org.youngmonkeys.ezyplatform.entity.UserRole;
import org.youngmonkeys.ezyplatform.entity.UserRoleName;
import org.youngmonkeys.ezyplatform.model.AdminAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.AdminModel;
import org.youngmonkeys.ezyplatform.model.AdminRoleModel;
import org.youngmonkeys.ezyplatform.model.ContentTemplateModel;
import org.youngmonkeys.ezyplatform.model.DataMappingModel;
import org.youngmonkeys.ezyplatform.model.LetterModel;
import org.youngmonkeys.ezyplatform.model.LetterReceiverModel;
import org.youngmonkeys.ezyplatform.model.LinkModel;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.NotificationModel;
import org.youngmonkeys.ezyplatform.model.NotificationReceiverModel;
import org.youngmonkeys.ezyplatform.model.SimpleLetterModel;
import org.youngmonkeys.ezyplatform.model.SimpleNotificationModel;
import org.youngmonkeys.ezyplatform.model.UserAccessTokenModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.model.UserRoleModel;
import org.youngmonkeys.ezyplatform.model.UserRoleNameModel;
import org.youngmonkeys.ezyplatform.util.LocalDateTimes;

public class DefaultEntityToModelConverter {
    protected final ZoneId zoneId;

    public AdminModel toModel(Admin entity) {
        if (entity == null) {
            return null;
        }
        return AdminModel.builder().id(entity.getId()).uuid(entity.getUuid()).username(entity.getUsername()).password(entity.getPassword()).email(entity.getEmail()).phone(entity.getPhone()).displayName(entity.getDisplayName()).url(entity.getUrl()).avatarImageId(entity.getAvatarImageId()).coverImageId(entity.getCoverImageId()).status(entity.getStatus()).password(entity.getPassword()).createdAt(this.toTimestamp(entity.getCreatedAt())).updatedAt(this.toTimestamp(entity.getUpdatedAt())).build();
    }

    public AdminAccessTokenModel toModel(AdminAccessToken entity) {
        if (entity == null) {
            return null;
        }
        return AdminAccessTokenModel.builder().adminId(entity.getAdminId()).accessToken(entity.getId()).renewalCount(entity.getRenewalCount()).status(entity.getStatus()).createdAt(entity.getCreatedAt()).expiredAt(entity.getExpiredAt()).createdAtTimestamp(this.toTimestamp(entity.getCreatedAt())).expiredAtTimestamp(this.toTimestamp(entity.getExpiredAt())).build();
    }

    public MediaModel toModel(Media entity) {
        return MediaModel.builder().id(entity.getId()).name(entity.getName()).url(entity.getUrl()).originalName(entity.getOriginalName()).type(entity.getType()).mimeType(entity.getMimeType()).uploadFrom(entity.getUploadFrom()).ownerUserId(entity.getOwnerUserId()).ownerAdminId(entity.getOwnerAdminId()).title(entity.getTitle()).caption(entity.getCaption()).alternativeText(entity.getAlternativeText()).description(entity.getDescription()).publicMedia(entity.isPublicMedia()).createdAt(this.toTimestamp(entity.getCreatedAt())).updatedAt(this.toTimestamp(entity.getUpdatedAt())).build();
    }

    public UserModel toModel(User entity) {
        return this.toModel(entity, true, true);
    }

    public UserModel toModel(User entity, boolean includePassword, boolean includeActivationKey) {
        if (entity == null) {
            return null;
        }
        return UserModel.builder().id(entity.getId()).uuid(entity.getUuid()).username(entity.getUsername()).email(entity.getEmail()).password(includePassword ? entity.getPassword() : "").phone(entity.getPhone()).url(entity.getUrl()).displayName(entity.getDisplayName()).avatarImageId(entity.getAvatarImageId()).coverImageId(entity.getCoverImageId()).activationKey(includeActivationKey ? entity.getActivationKey() : "").status(entity.getStatus()).createdAt(this.toTimestamp(entity.getCreatedAt())).updatedAt(this.toTimestamp(entity.getUpdatedAt())).build();
    }

    public UserAccessTokenModel toModel(UserAccessToken entity) {
        if (entity == null) {
            return null;
        }
        return UserAccessTokenModel.builder().userId(entity.getUserId()).accessToken(entity.getId()).renewalCount(entity.getRenewalCount()).status(entity.getStatus()).createdAt(entity.getCreatedAt()).expiredAt(entity.getExpiredAt()).createdAtTimestamp(this.toTimestamp(entity.getCreatedAt())).expiredAtTimestamp(this.toTimestamp(entity.getExpiredAt())).build();
    }

    public UserRoleNameModel toModel(UserRoleName entity) {
        if (entity == null) {
            return null;
        }
        return UserRoleNameModel.builder().id(entity.getId()).name(entity.getName()).displayName(entity.getDisplayName()).priority(entity.getPriority()).createdAt(this.toTimestamp(entity.getCreatedAt())).updatedAt(this.toTimestamp(entity.getUpdatedAt())).build();
    }

    public SimpleNotificationModel toModel(Notification entity) {
        if (entity == null) {
            return null;
        }
        return SimpleNotificationModel.builder().id(entity.getId()).type(entity.getType()).title(entity.getTitle()).content(entity.getContent()).contentType(entity.getContentType()).iconImage(entity.getIconImage()).deepLink(entity.getDeepLink()).fromAdminId(entity.getFromAdminId()).fromUserId(entity.getFromUserId()).status(entity.getStatus()).createdAt(this.toTimestamp(entity.getCreatedAt())).build();
    }

    public NotificationModel toModel(Notification notification, NotificationReceiver notificationReceiver, boolean includeFromAdmin) {
        return NotificationModel.builder().id(notification.getId()).title(notification.getTitle()).content(notification.getContent()).contentType(notification.getContentType()).iconImage(notification.getIconImage()).deepLink(notification.getDeepLink()).status(notification.getStatus()).fromAdminId(includeFromAdmin ? notification.getFromAdminId() : 0L).fromUserId(notification.getFromUserId()).toAdminId(notificationReceiver.getToAdminId()).toUserId(notificationReceiver.getToUserId()).notificationReceiverId(notificationReceiver.getId()).confidenceLevel(notificationReceiver.getConfidenceLevel()).importantLevel(notificationReceiver.getImportantLevel()).receiveStatus(notificationReceiver.getStatus()).sentAt(this.toTimestamp(notificationReceiver.getSentAt())).receivedAt(this.toTimestamp(notificationReceiver.getReceivedAt())).readAt(this.toTimestamp(notificationReceiver.getReadAt())).build();
    }

    public NotificationReceiverModel toModel(NotificationReceiver entity) {
        if (entity == null) {
            return null;
        }
        return NotificationReceiverModel.builder().id(entity.getId()).notificationId(entity.getNotificationId()).toAdminId(entity.getToAdminId()).toUserId(entity.getToUserId()).confidenceLevel(entity.getConfidenceLevel()).importantLevel(entity.getImportantLevel()).status(entity.getStatus()).sentAt(this.toTimestamp(entity.getSentAt())).receivedAt(this.toTimestamp(entity.getReceivedAt())).readAt(this.toTimestamp(entity.getReadAt())).build();
    }

    public SimpleLetterModel toModel(Letter entity) {
        if (entity == null) {
            return null;
        }
        return SimpleLetterModel.builder().id(entity.getId()).type(entity.getType()).title(entity.getTitle()).content(entity.getContent()).contentType(entity.getContentType()).fromAdminId(entity.getFromAdminId()).fromUserId(entity.getFromUserId()).parentId(entity.getParentId()).status(entity.getStatus()).createdAt(this.toTimestamp(entity.getCreatedAt())).build();
    }

    public LetterModel toModel(Letter letter, LetterReceiver letterReceiver) {
        return LetterModel.builder().id(letter.getId()).title(letter.getTitle()).content(letter.getContent()).contentType(letter.getContentType()).status(letter.getStatus()).fromAdminId(letter.getFromAdminId()).fromUserId(letter.getFromUserId()).toAdminId(letterReceiver.getToAdminId()).toUserId(letterReceiver.getToUserId()).parentId(letter.getParentId()).letterReceiverId(letterReceiver.getId()).notificationReceiverId(letterReceiver.getNotificationReceiverId()).confidenceLevel(letterReceiver.getConfidenceLevel()).importantLevel(letterReceiver.getImportantLevel()).receiveStatus(letterReceiver.getStatus()).sentAt(this.toTimestamp(letterReceiver.getSentAt())).receivedAt(this.toTimestamp(letterReceiver.getReceivedAt())).readAt(this.toTimestamp(letterReceiver.getReadAt())).build();
    }

    public LetterReceiverModel toModel(LetterReceiver entity) {
        if (entity == null) {
            return null;
        }
        return LetterReceiverModel.builder().id(entity.getId()).letterId(entity.getLetterId()).toAdminId(entity.getToAdminId()).toUserId(entity.getToUserId()).notificationReceiverId(entity.getNotificationReceiverId()).confidenceLevel(entity.getConfidenceLevel()).importantLevel(entity.getImportantLevel()).status(entity.getStatus()).sentAt(this.toTimestamp(entity.getSentAt())).receivedAt(this.toTimestamp(entity.getReceivedAt())).readAt(this.toTimestamp(entity.getReadAt())).build();
    }

    public ContentTemplateModel toModel(ContentTemplate entity) {
        if (entity == null) {
            return null;
        }
        return ContentTemplateModel.builder().id(entity.getId()).type(entity.getTemplateType()).name(entity.getTemplateName()).titleTemplate(entity.getTitleTemplate()).contentTemplate(entity.getContentTemplate()).contentType(entity.getContentType()).creatorId(entity.getCreatorId()).status(entity.getStatus()).createdAt(this.toTimestamp(entity.getCreatedAt())).updatedAt(this.toTimestamp(entity.getUpdatedAt())).build();
    }

    public AdminRoleModel toModel(AdminRole entity) {
        if (entity == null) {
            return null;
        }
        return AdminRoleModel.builder().adminId(entity.getAdminId()).roleId(entity.getRoleId()).createdAt(this.toTimestamp(entity.getCreatedAt())).build();
    }

    public UserRoleModel toModel(UserRole entity) {
        if (entity == null) {
            return null;
        }
        return UserRoleModel.builder().userId(entity.getUserId()).roleId(entity.getRoleId()).createdAt(this.toTimestamp(entity.getCreatedAt())).build();
    }

    public LinkModel toModel(Link entity, MediaNameModel image) {
        return this.toModel(entity, MediaNameModel.getMediaUrlOrNull(image));
    }

    public LinkModel toModel(Link entity, String imageUrl) {
        if (entity == null) {
            return null;
        }
        return LinkModel.builder().id(entity.getId()).linkType(entity.getLinkType()).linkUri(entity.getLinkUri()).imageId(entity.getImageId()).imageUrl(imageUrl).description(entity.getDescription()).sourceType(entity.getSourceType()).sourceId(entity.getSourceId()).createdAt(this.toTimestamp(entity.getCreatedAt())).updatedAt(this.toTimestamp(entity.getUpdatedAt())).build();
    }

    public DataMappingModel toModel(DataMapping entity) {
        if (entity == null) {
            return null;
        }
        return DataMappingModel.builder().mappingName(entity.getMappingName()).fromDataId(entity.getFromDataId()).toDataId(entity.getToDataId()).metadata(entity.getMetadata()).mappedAt(this.toTimestamp(entity.getMappedAt())).build();
    }

    public long toTimestamp(LocalDateTime localDateTime) {
        return LocalDateTimes.toTimestamp(localDateTime, this.zoneId);
    }

    public DefaultEntityToModelConverter(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

