/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.tvd12.ezyfox.io.EzyStrings;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;

public class MediaModel {
    private long id;
    private String name;
    private String url;
    private String originalName;
    private UploadFrom uploadFrom;
    private MediaType type;
    private String mimeType;
    private long ownerUserId;
    private long ownerAdminId;
    private String title;
    private String caption;
    private String alternativeText;
    private String description;
    private boolean publicMedia;
    private long createdAt;
    private long updatedAt;

    public static String getMediaUrlOrNull(MediaModel media) {
        return MediaModel.getMediaUrlOrDefault(media, null);
    }

    public static String getMediaUrlOrDefault(MediaModel media, String defaultUrl) {
        return media == null ? defaultUrl : media.getUrlOrDefault(defaultUrl);
    }

    public static String toMediaUrlOrDefault(String mediaName, String mediaUrl, String defaultUrl) {
        return EzyStrings.isBlank((String)mediaUrl) ? (EzyStrings.isBlank((String)mediaName) ? defaultUrl : "/api/v1/media/" + mediaName) : mediaUrl;
    }

    public static String toMeMediaUrlOrDefault(String mediaName, String mediaUrl, String defaultUrl) {
        return EzyStrings.isBlank((String)mediaUrl) ? (EzyStrings.isBlank((String)mediaName) ? defaultUrl : "/api/v1/me/media/" + mediaName) : mediaUrl;
    }

    public String getUrlOrNull() {
        return this.getUrlOrDefault(null);
    }

    public String getUrlOrDefault(String defaultUrl) {
        return MediaModel.toMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    public String getMeUrlOrDefault(String defaultUrl) {
        return MediaModel.toMeMediaUrlOrDefault(this.name, this.url, defaultUrl);
    }

    MediaModel(long id, String name, String url, String originalName, UploadFrom uploadFrom, MediaType type, String mimeType, long ownerUserId, long ownerAdminId, String title, String caption, String alternativeText, String description, boolean publicMedia, long createdAt, long updatedAt) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.originalName = originalName;
        this.uploadFrom = uploadFrom;
        this.type = type;
        this.mimeType = mimeType;
        this.ownerUserId = ownerUserId;
        this.ownerAdminId = ownerAdminId;
        this.title = title;
        this.caption = caption;
        this.alternativeText = alternativeText;
        this.description = description;
        this.publicMedia = publicMedia;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public static MediaModelBuilder builder() {
        return new MediaModelBuilder();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public UploadFrom getUploadFrom() {
        return this.uploadFrom;
    }

    public MediaType getType() {
        return this.type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getOwnerUserId() {
        return this.ownerUserId;
    }

    public long getOwnerAdminId() {
        return this.ownerAdminId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getAlternativeText() {
        return this.alternativeText;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPublicMedia() {
        return this.publicMedia;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public static class MediaModelBuilder {
        private long id;
        private String name;
        private String url;
        private String originalName;
        private UploadFrom uploadFrom;
        private MediaType type;
        private String mimeType;
        private long ownerUserId;
        private long ownerAdminId;
        private String title;
        private String caption;
        private String alternativeText;
        private String description;
        private boolean publicMedia;
        private long createdAt;
        private long updatedAt;

        MediaModelBuilder() {
        }

        public MediaModelBuilder id(long id) {
            this.id = id;
            return this;
        }

        public MediaModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MediaModelBuilder url(String url) {
            this.url = url;
            return this;
        }

        public MediaModelBuilder originalName(String originalName) {
            this.originalName = originalName;
            return this;
        }

        public MediaModelBuilder uploadFrom(UploadFrom uploadFrom) {
            this.uploadFrom = uploadFrom;
            return this;
        }

        public MediaModelBuilder type(MediaType type) {
            this.type = type;
            return this;
        }

        public MediaModelBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public MediaModelBuilder ownerUserId(long ownerUserId) {
            this.ownerUserId = ownerUserId;
            return this;
        }

        public MediaModelBuilder ownerAdminId(long ownerAdminId) {
            this.ownerAdminId = ownerAdminId;
            return this;
        }

        public MediaModelBuilder title(String title) {
            this.title = title;
            return this;
        }

        public MediaModelBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public MediaModelBuilder alternativeText(String alternativeText) {
            this.alternativeText = alternativeText;
            return this;
        }

        public MediaModelBuilder description(String description) {
            this.description = description;
            return this;
        }

        public MediaModelBuilder publicMedia(boolean publicMedia) {
            this.publicMedia = publicMedia;
            return this;
        }

        public MediaModelBuilder createdAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public MediaModelBuilder updatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public MediaModel build() {
            return new MediaModel(this.id, this.name, this.url, this.originalName, this.uploadFrom, this.type, this.mimeType, this.ownerUserId, this.ownerAdminId, this.title, this.caption, this.alternativeText, this.description, this.publicMedia, this.createdAt, this.updatedAt);
        }

        public String toString() {
            return "MediaModel.MediaModelBuilder(id=" + this.id + ", name=" + this.name + ", url=" + this.url + ", originalName=" + this.originalName + ", uploadFrom=" + (Object)((Object)this.uploadFrom) + ", type=" + (Object)((Object)this.type) + ", mimeType=" + this.mimeType + ", ownerUserId=" + this.ownerUserId + ", ownerAdminId=" + this.ownerAdminId + ", title=" + this.title + ", caption=" + this.caption + ", alternativeText=" + this.alternativeText + ", description=" + this.description + ", publicMedia=" + this.publicMedia + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

