/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzySets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.DataMappingId;
import org.youngmonkeys.ezyplatform.model.DataMappingModel;
import org.youngmonkeys.ezyplatform.model.SaveDataMappingModel;
import org.youngmonkeys.ezyplatform.repo.DataMappingRepository;
import org.youngmonkeys.ezyplatform.result.DataFromToIdResult;
import org.youngmonkeys.ezyplatform.service.DataMappingService;

public class DefaultDataMappingService
implements DataMappingService {
    private final DataMappingRepository dataMappingRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void saveDataMapping(String mappingName, long fromDataId, long toDataId) {
        this.dataMappingRepository.save(this.modelToEntityConverter.toEntity(SaveDataMappingModel.builder().mappingName(mappingName).fromDataId(fromDataId).toDataId(toDataId).build()));
    }

    @Override
    public void saveDataMappings(String mappingName, long fromDataId, Collection<Long> toDataIds) {
        this.dataMappingRepository.save(this.modelToEntityConverter.toEntities(mappingName, fromDataId, toDataIds));
    }

    @Override
    public void saveDataMappings(String mappingName, Collection<Long> fromDataIds, long toDataId) {
        this.dataMappingRepository.save(this.modelToEntityConverter.toEntities(mappingName, fromDataIds, toDataId));
    }

    @Override
    public void saveDataMappings(String mappingName, Map<Long, Long> toDataIdByFromDataId) {
        this.dataMappingRepository.save(this.modelToEntityConverter.toEntities(mappingName, toDataIdByFromDataId));
    }

    @Override
    public void removeDataMapping(String mappingName, long fromDataId, long toDataId) {
        this.dataMappingRepository.delete(new DataMappingId(mappingName, fromDataId, toDataId));
    }

    @Override
    public void removeDataMappingByFromDataId(String mappingName, long fromDataId) {
        this.dataMappingRepository.deleteByMappingNameAndFromDataId(mappingName, fromDataId);
    }

    @Override
    public void removeDataMappingByToDataId(String mappingName, long toDataId) {
        this.dataMappingRepository.deleteByMappingNameAndToDataId(mappingName, toDataId);
    }

    @Override
    public void removeDataMappings(String mappingName, long fromDataId, Collection<Long> toDataIds) {
        if (toDataIds.isEmpty()) {
            return;
        }
        this.dataMappingRepository.deleteByIds(EzyLists.newArrayList(toDataIds, toDataId -> new DataMappingId(mappingName, fromDataId, (long)toDataId)));
    }

    @Override
    public void removeDataMappings(String mappingName, Collection<Long> fromDataIds, long toDataId) {
        if (fromDataIds.isEmpty()) {
            return;
        }
        this.dataMappingRepository.deleteByIds(EzyLists.newArrayList(fromDataIds, fromDataId -> new DataMappingId(mappingName, (long)fromDataId, toDataId)));
    }

    @Override
    public void removeDataMappings(String mappingName, Map<Long, Long> toDataIdByFromDataId) {
        if (toDataIdByFromDataId.isEmpty()) {
            return;
        }
        this.dataMappingRepository.deleteByIds(EzyLists.newArrayList(toDataIdByFromDataId.entrySet(), e -> new DataMappingId(mappingName, (Long)e.getKey(), (Long)e.getValue())));
    }

    @Override
    public void removeDataMappingsByFromDataIds(String mappingName, Collection<Long> fromDataIds) {
        if (fromDataIds.isEmpty()) {
            return;
        }
        this.dataMappingRepository.deleteByMappingNameAndFromDataIdIn(mappingName, fromDataIds);
    }

    @Override
    public void removeDataMappingsByToDataIds(String mappingName, Collection<Long> toDataIds) {
        if (toDataIds.isEmpty()) {
            return;
        }
        this.dataMappingRepository.deleteByMappingNameAndToDataIdIn(mappingName, toDataIds);
    }

    @Override
    public DataMappingModel getMappingToDataByNameAndFromDataId(String mappingName, long fromDataId) {
        return this.entityToModelConverter.toModel(this.dataMappingRepository.findByMappingNameAndFromDataIdOrderByMappedAtDesc(mappingName, fromDataId));
    }

    @Override
    public DataMappingModel getMappingFromDataByNameAndToDataId(String mappingName, long toDataId) {
        return this.entityToModelConverter.toModel(this.dataMappingRepository.findByMappingNameAndToDataIdOrderByMappedAtDesc(mappingName, toDataId));
    }

    @Override
    public Set<Long> getMappingToDataIdsByNameAndFromDataId(String mappingName, long fromDataId) {
        return EzySets.newHashSet(this.dataMappingRepository.findDataFromToIdsByMappingNameAndFromDataIdOrderByMappedAtDesc(mappingName, fromDataId), DataFromToIdResult::getToDataId);
    }

    @Override
    public Set<Long> getMappingToDataIdsByNameAndFromDataIds(String mappingName, Collection<Long> fromDataIds) {
        if (fromDataIds.isEmpty()) {
            return Collections.emptySet();
        }
        return EzySets.newHashSet(this.dataMappingRepository.findDataFromToIdsByMappingNameAndFromDataIdInOrderByMappedAtDesc(mappingName, fromDataIds), DataFromToIdResult::getToDataId);
    }

    @Override
    public Map<Long, Long> getMappingToDataIdMapByNameAndFromDataIds(String mappingName, Collection<Long> fromDataIds) {
        if (fromDataIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dataMappingRepository.findDataFromToIdsByMappingNameAndFromDataIdInOrderByMappedAtDesc(mappingName, fromDataIds).stream().collect(Collectors.toMap(DataFromToIdResult::getFromDataId, DataFromToIdResult::getToDataId, (o, n) -> o));
    }

    @Override
    public Map<Long, List<Long>> getMappingToDataIdsMapByNameAndFromDataIds(String mappingName, Collection<Long> fromDataIds) {
        if (fromDataIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dataMappingRepository.findDataFromToIdsByMappingNameAndFromDataIdInOrderByMappedAtDesc(mappingName, fromDataIds).stream().collect(Collectors.groupingBy(DataFromToIdResult::getFromDataId, Collectors.mapping(DataFromToIdResult::getToDataId, Collectors.toList())));
    }

    @Override
    public Set<Long> getMappingFromDataIdsByNameAndToDataId(String mappingName, long toDataId) {
        return EzySets.newHashSet(this.dataMappingRepository.findDataFromToIdsByMappingNameAndToDataIdOrderByMappedAtDesc(mappingName, toDataId), DataFromToIdResult::getFromDataId);
    }

    @Override
    public Set<Long> getMappingFromDataIdsByNameAndToDataIds(String mappingName, Collection<Long> toDataIds) {
        if (toDataIds.isEmpty()) {
            return Collections.emptySet();
        }
        return EzySets.newHashSet(this.dataMappingRepository.findDataFromToIdsByMappingNameAndToDataIdInOrderByMappedAtDesc(mappingName, toDataIds), DataFromToIdResult::getFromDataId);
    }

    @Override
    public Map<Long, Long> getMappingFromDataIdMapByNameAndToDataIds(String mappingName, Collection<Long> toDataIds) {
        if (toDataIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dataMappingRepository.findDataFromToIdsByMappingNameAndToDataIdInOrderByMappedAtDesc(mappingName, toDataIds).stream().collect(Collectors.toMap(DataFromToIdResult::getToDataId, DataFromToIdResult::getFromDataId, (o, n) -> o));
    }

    @Override
    public Map<Long, List<Long>> getMappingFromDataIdsMapByNameAndToDataIds(String mappingName, Collection<Long> toDataIds) {
        if (toDataIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.dataMappingRepository.findDataFromToIdsByMappingNameAndToDataIdInOrderByMappedAtDesc(mappingName, toDataIds).stream().collect(Collectors.groupingBy(DataFromToIdResult::getToDataId, Collectors.mapping(DataFromToIdResult::getFromDataId, Collectors.toList())));
    }

    @Override
    public List<DataMappingModel> getMappingDataListByMappingNameAndFromDataIds(String mappingName, Collection<Long> fromDataIds) {
        if (fromDataIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dataMappingRepository.findByMappingNameAndFromDataIdInOrderByMappedAtDesc(mappingName, fromDataIds).stream().map(this.entityToModelConverter::toModel).collect(Collectors.toList());
    }

    @Override
    public List<DataMappingModel> getMappingDataListByMappingNameAndToDataIds(String mappingName, Collection<Long> toDataIds) {
        if (toDataIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.dataMappingRepository.findByMappingNameAndToDataIdInOrderByMappedAtDesc(mappingName, toDataIds).stream().map(this.entityToModelConverter::toModel).collect(Collectors.toList());
    }

    public DefaultDataMappingService(DataMappingRepository dataMappingRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter) {
        this.dataMappingRepository = dataMappingRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

