/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.Next;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.entity.UserMeta;
import org.youngmonkeys.ezyplatform.repo.UserMetaRepository;
import org.youngmonkeys.ezyplatform.repo.UserMetaTransactionalRepository;
import org.youngmonkeys.ezyplatform.service.UserMetaService;
import org.youngmonkeys.ezyplatform.util.Strings;

public class DefaultUserMetaService
implements UserMetaService {
    private final UserMetaRepository userMetaRepository;
    private final UserMetaTransactionalRepository userMetaTransactionalRepository;

    @Override
    public void saveUserMeta(long userId, String metaKey, String metaValue) {
        UserMeta entity = new UserMeta();
        entity.setUserId(userId);
        entity.setMetaKey(metaKey);
        entity.setMetaValue(metaValue);
        entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
        this.userMetaRepository.save(entity);
    }

    @Override
    public void saveUserMeta(long userId, String metaKey, List<String> metaValues) {
        List entities = EzyLists.newArrayList(metaValues, metaValue -> {
            UserMeta entity = new UserMeta();
            entity.setUserId(userId);
            entity.setMetaKey(metaKey);
            entity.setMetaValue((String)metaValue);
            entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
            return entity;
        });
        this.userMetaRepository.save(entities);
    }

    @Override
    public void saveUserMetaUniqueKey(long userId, String metaKey, String metaValue, String metaTextValue) {
        this.userMetaTransactionalRepository.saveUserMetaUniqueKey(userId, metaKey, metaValue, metaTextValue);
    }

    @Override
    public void saveUserMetaIfAbsent(long userId, String metaKey, String metaValue) {
        this.userMetaTransactionalRepository.saveUserMetaUniqueKeyValue(userId, metaKey, metaValue);
    }

    @Override
    public BigDecimal increaseUserMetaValue(long userId, String metaKey, BigDecimal value) {
        return this.userMetaTransactionalRepository.increaseMetaValue(userId, metaKey, value);
    }

    @Override
    public boolean containsUserMeta(long userId, String metaKey, String metaValue) {
        return this.userMetaRepository.findByUserIdAndMetaKeyAndMetaValue(userId, metaKey, metaValue).isPresent();
    }

    @Override
    public long getUserIdByMeta(String metaKey, String metaValue) {
        return this.userMetaRepository.findByMetaKeyAndMetaValue(metaKey, metaValue).map(UserMeta::getUserId).orElse(0L);
    }

    @Override
    public String getMetaValueByUserIdAndMetaKey(long userId, String metaKey) {
        return this.userMetaRepository.findByUserIdAndMetaKey(userId, metaKey).map(UserMeta::getMetaValue).orElse(null);
    }

    @Override
    public String getLatestMetaValueByUserIdAndMetaKey(long userId, String metaKey) {
        return this.userMetaRepository.findByUserIdAndMetaKeyOrderByIdDesc(userId, metaKey).map(UserMeta::getMetaValue).orElse(null);
    }

    @Override
    public String getMetaTextValueByUserIdAndMetaKey(long userId, String metaKey) {
        return this.userMetaRepository.findByUserIdAndMetaKey(userId, metaKey).map(UserMeta::getMetaTextValue).orElse(null);
    }

    @Override
    public String getLatestMetaTextValueByUserIdAndMetaKey(long userId, String metaKey) {
        return this.userMetaRepository.findByUserIdAndMetaKeyOrderByIdDesc(userId, metaKey).map(UserMeta::getMetaTextValue).orElse(null);
    }

    @Override
    public List<String> getMetaValuesByUserIdAndMetaKey(long userId, String metaKey, int limit) {
        return EzyLists.newArrayList(this.userMetaRepository.findByUserIdAndMetaKey(userId, metaKey, Next.limit((long)limit)), UserMeta::getMetaValue);
    }

    @Override
    public Map<String, String> getUserMetaValues(long userId) {
        return this.userMetaRepository.findByUserId(userId).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(UserMeta::getMetaKey, UserMeta::getMetaValue, (o, n) -> n));
    }

    @Override
    public Map<String, Long> getUserIdMapByMetaValues(String metaKey, Collection<String> metaValues) {
        if (metaValues.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userMetaRepository.findByMetaKeyAndMetaValueIn(metaKey, metaValues).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(UserMeta::getMetaValue, UserMeta::getUserId, (o, n) -> n));
    }

    @Override
    public Map<Long, String> getUserMetaValueMapByUserIds(Collection<Long> userIds, String metaKey) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userMetaRepository.findByUserIdInAndMetaKey(userIds, metaKey).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(UserMeta::getUserId, UserMeta::getMetaValue, (o, n) -> n));
    }

    @Override
    public Map<String, String> getUserMetaValueMapByUserIdAndMetaKeys(long userId, Collection<String> metaKeys) {
        if (metaKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userMetaRepository.findByUserIdAndMetaKeyIn(userId, metaKeys).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(UserMeta::getMetaKey, UserMeta::getMetaValue, (o, n) -> n));
    }

    @Override
    public Map<Long, String> getUserMetaTextValueMapByUserIds(Collection<Long> userIds, String metaKey) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.userMetaRepository.findByUserIdInAndMetaKey(userIds, metaKey).stream().filter(it -> it.getMetaTextValue() != null).collect(Collectors.toMap(UserMeta::getUserId, UserMeta::getMetaTextValue, (o, n) -> n));
    }

    public DefaultUserMetaService(UserMetaRepository userMetaRepository, UserMetaTransactionalRepository userMetaTransactionalRepository) {
        this.userMetaRepository = userMetaRepository;
        this.userMetaTransactionalRepository = userMetaTransactionalRepository;
    }
}

