/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyMapBuilder;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Map;

public final class Durations {
    private static final Map<String, Long> MILLIS_BY_SYMBOL = EzyMapBuilder.mapBuilder().put((Object)"ms", (Object)1L).put((Object)"s", (Object)1000L).put((Object)"m", (Object)60000L).put((Object)"h", (Object)3600000L).put((Object)"d", (Object)86400000L).put((Object)"w", (Object)604800000L).put((Object)"M", (Object)2592000000L).put((Object)"y", (Object)31536000000L).toMap();

    private Durations() {
    }

    public static long durationStringToMillis(String str) {
        if (EzyStrings.isBlank((String)str)) {
            return 0L;
        }
        long answer = 0L;
        long strLength = str.length();
        StringBuilder number = new StringBuilder();
        StringBuilder lastSymbol = new StringBuilder();
        int i = 0;
        while ((long)i < strLength) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                number.append(ch);
                lastSymbol.delete(0, lastSymbol.length());
            } else {
                char chNext;
                lastSymbol.append(ch);
                if ((long)(i + 1) < strLength && ((chNext = str.charAt(i + 1)) < '0' || chNext > '9')) {
                    lastSymbol.append(chNext);
                    ++i;
                }
                Long millis = MILLIS_BY_SYMBOL.get(lastSymbol.toString());
                int numberLength = number.length();
                if (millis != null && numberLength > 0) {
                    answer += Long.parseLong(number.toString()) * millis;
                    number.delete(0, numberLength);
                } else {
                    answer = -1L;
                    break;
                }
            }
            ++i;
        }
        if (lastSymbol.length() == 0) {
            answer = -1L;
        }
        return answer;
    }

    public static int calculateDurationInMinute(long from, long to) {
        if (to <= from) {
            return 0;
        }
        long durationSeconds = (to - from) / 1000L;
        return (int)(durationSeconds % 60L == 0L ? durationSeconds / 60L : durationSeconds / 60L + 1L);
    }

    public static long calculateDurationToNextTime(LocalDateTime start, int nextHour, int nextMinute, int nextSecond) {
        LocalDateTime next = LocalDateTime.of(start.getYear(), start.getMonth(), start.getDayOfMonth(), nextHour, nextMinute, nextSecond);
        if (next.isBefore(start)) {
            next = next.plusDays(1L);
        }
        return Duration.between(start, next).toMillis();
    }
}

