/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import com.tvd12.ezyfox.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Set;
import org.youngmonkeys.ezyplatform.exception.InvalidHtmlContentException;
import org.youngmonkeys.ezyplatform.util.Strings;

public final class Htmls {
    public static final String TAG_NAME_PRE = "pre";
    public static final String TAG_NAME_SCRIPT = "script";
    public static final String HTML_COMMENT_TAG_OPEN = "!--";
    public static final String HTML_COMMENT_TAG_CLOSE = "--";
    public static final Set<String> HTML_TAGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"!DOCTYPE", "a", "abbreviation", "acronym", "address", "anchor", "applet", "area", "article", "aside", "audio", "base", "basefont", "bdi", "bdo", "bgsound", "big", "blockquote", "b", "body", "bold", "break", "button", "caption", "canvas", "center", "cite", "code", "colgroup", "column", "comment", "data", "datalist", "dd", "define", "delete", "details", "dialog", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "head", "header", "heading", "hgroup", "hr", "html", "h1", "h2", "h3", "h4", "h5", "h6", "iframe", "i", "image", "input", "ins", "isindex", "italic", "kbd", "keygen", "label", "legend", "li", "list", "main", "mark", "marquee", "map", "menuitem", "meta", "meter", "nav", "nobreak", "noembed", "noscript", "object", "ol", "optgroup", "option", "output", "p", "paragraphs", "param", "phrase", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "sup", "summary", "svg", "table", "tbody", "td", "template", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "ul", "underline", "var", "video", "wbr", "xmp"}));
    public static final Set<String> NO_CLOSED_TAGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"area", "base", "br", "col", "command", "!DOCTYPE", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"}));

    private Htmls() {
    }

    public static boolean containsScriptTag(String content) {
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            char ch = content.charAt(i);
            if (ch != '<') continue;
            int k = 0;
            ++i;
            while (i < contentLength && (ch = content.charAt(i)) == '<') {
                ++i;
            }
            while (i < contentLength && ((ch = content.charAt(i)) == ' ' || ch == '\t' || ch == '\n')) {
                ++i;
            }
            while (i < contentLength) {
                ch = content.charAt(i);
                if (ch != TAG_NAME_SCRIPT.charAt(k++)) {
                    return false;
                }
                if (k == TAG_NAME_SCRIPT.length()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String escapeHtmlTag(String content) {
        return content.replace("<", "&lt").replace(">", "&gt");
    }

    public static String escapeScriptTag(String content) {
        StringBuilder answer = new StringBuilder();
        int contentLength = content.length();
        block0: for (int i = 0; i < contentLength; ++i) {
            String tagName;
            char ch = content.charAt(i);
            if (ch != '<') {
                answer.append(ch);
                continue;
            }
            ++i;
            while (i < contentLength && (ch = content.charAt(i)) == '<') {
                answer.append(ch);
                ++i;
            }
            StringBuilder before = new StringBuilder();
            while (i < contentLength && ((ch = content.charAt(i)) == ' ' || ch == '\t' || ch == '\n' || ch == '/')) {
                before.append(ch);
                ++i;
            }
            StringBuilder tagNameBuilder = new StringBuilder();
            while (i < contentLength) {
                ch = content.charAt(i);
                if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '>') {
                    --i;
                    break;
                }
                tagNameBuilder.append(ch);
                ++i;
            }
            if ((tagName = tagNameBuilder.toString()).equals(TAG_NAME_SCRIPT)) {
                answer.append("&lt").append((CharSequence)before).append(tagName);
                ++i;
                while (i < contentLength) {
                    ch = content.charAt(i);
                    if (ch == '>') {
                        answer.append("&gt");
                        continue block0;
                    }
                    answer.append(ch);
                    ++i;
                }
                continue;
            }
            answer.append("<").append((CharSequence)before).append(tagName);
        }
        return answer.toString();
    }

    public static void validateHtmlContent(String content) {
        Htmls.validateHtmlContent(content, true);
    }

    public static void validateHtmlContent(String content, boolean acceptMarkdown) {
        String openTag;
        char ch = '\u0000';
        ArrayDeque<String> openTags = new ArrayDeque<String>();
        int contentLength = content.length();
        block0: for (int i = 0; i < contentLength; ++i) {
            char firstCh;
            int backslashCount = 0;
            while (i < contentLength && (ch = (char)content.charAt(i)) == '\\') {
                ++backslashCount;
                ++i;
            }
            if (ch == '`' && backslashCount % 2 == 0 && acceptMarkdown) {
                StringBuilder marks = new StringBuilder();
                while (i < contentLength && (ch = (char)content.charAt(i)) == '`') {
                    marks.append(ch);
                    ++i;
                }
                i = Htmls.validateCodeContainerTag(content, contentLength, i, marks.toString(), false);
                continue;
            }
            if (ch != '<') continue;
            ++i;
            while (i < contentLength && (ch = (char)content.charAt(i)) == '<') {
                ++i;
            }
            boolean isOpenTag = true;
            while (i < contentLength) {
                ch = content.charAt(i);
                if (ch == '/') {
                    isOpenTag = false;
                }
                if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '/') break;
                ++i;
            }
            StringBuilder tagNameBuilder = new StringBuilder();
            while (i < contentLength && (ch = content.charAt(i)) != ' ' && ch != '\t' && ch != '\n' && ch != '/' && ch != '>') {
                tagNameBuilder.append(ch);
                ++i;
            }
            String tagName = tagNameBuilder.toString();
            if (tagName.equals(TAG_NAME_SCRIPT)) {
                i = Htmls.validateCodeContainerTag(content, contentLength, i, TAG_NAME_SCRIPT, true);
                continue;
            }
            if (tagName.isEmpty() || ((firstCh = tagName.charAt(0)) < 'a' || firstCh > 'z') && (firstCh < 'A' || firstCh > 'Z')) continue;
            if (tagName.startsWith(HTML_COMMENT_TAG_OPEN)) {
                ++i;
                while (i < contentLength) {
                    ch = content.charAt(i);
                    if (ch == '>' && Strings.endsWith(content, i, HTML_COMMENT_TAG_CLOSE)) {
                        ++i;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            boolean startAttribute = false;
            boolean startAttributeDoubleQuotes = false;
            while (i < contentLength) {
                char nextCh;
                ch = content.charAt(i);
                char beforeCh = content.charAt(i - 1);
                char c = nextCh = i < contentLength - 1 ? content.charAt(i + 1) : (char)'\u0000';
                if (ch == '/' && nextCh == '>' || ch == '>') {
                    if (!startAttribute) break;
                    throw new InvalidHtmlContentException(tagName, "incomplete_tag_attribute", i, Htmls.subNearbyErrorContent(content, i));
                }
                if (ch == '=') {
                    if (startAttribute && !startAttributeDoubleQuotes) {
                        throw new InvalidHtmlContentException(tagName, "invalid_tag_attribute", i, Htmls.subNearbyErrorContent(content, i));
                    }
                    startAttribute = true;
                } else if (ch == '\"') {
                    if (!startAttribute) {
                        throw new InvalidHtmlContentException(tagName, "invalid_tag_attribute", i, Htmls.subNearbyErrorContent(content, i));
                    }
                    if (beforeCh == '\\' && !startAttributeDoubleQuotes) {
                        throw new InvalidHtmlContentException(tagName, "invalid_tag_attribute", i, Htmls.subNearbyErrorContent(content, i));
                    }
                    if (beforeCh != '\\') {
                        boolean bl = startAttributeDoubleQuotes = !startAttributeDoubleQuotes;
                        if (!startAttributeDoubleQuotes) {
                            startAttribute = false;
                        }
                    }
                } else if (startAttribute && !startAttributeDoubleQuotes && ch != ' ' && ch != '\t' && ch != '\n') {
                    throw new InvalidHtmlContentException(tagName, "tag_attribute_must_start_with_double_quotes", i, Htmls.subNearbyErrorContent(content, i));
                }
                ++i;
            }
            boolean hasGtSign = false;
            boolean selfCloseTag = false;
            while (i < contentLength) {
                ch = content.charAt(i);
                if (ch == '/') {
                    selfCloseTag = true;
                } else {
                    if (ch == '>') {
                        hasGtSign = true;
                        break;
                    }
                    if (selfCloseTag) {
                        throw new InvalidHtmlContentException(tagName, "invalid_tag_content", i, Htmls.subNearbyErrorContent(content, i));
                    }
                    if (ch == '\"') {
                        boolean hasDoubleQuotationMarks = false;
                        ++i;
                        while (i < contentLength) {
                            char beforeCh = content.charAt(i - 1);
                            ch = content.charAt(i);
                            if (ch == '\"' && beforeCh != '\\') {
                                hasDoubleQuotationMarks = true;
                                break;
                            }
                            ++i;
                        }
                        if (!hasDoubleQuotationMarks) {
                            throw new InvalidHtmlContentException(tagName, "missing_close_double_quotation_marks", i, Htmls.subNearbyErrorContent(content, i));
                        }
                    }
                }
                ++i;
            }
            if (selfCloseTag && hasGtSign || !HTML_TAGS.contains(tagName)) continue;
            if (hasGtSign) {
                String openTag2 = (String)openTags.peek();
                if (isOpenTag) {
                    openTags.push(tagName);
                    continue;
                }
                if (openTag2 == null) {
                    throw new InvalidHtmlContentException(tagName, "missing_open_tag", i, Htmls.subNearbyErrorContent(content, i));
                }
                while (NO_CLOSED_TAGS.contains(openTag2)) {
                    openTags.pop();
                    openTag2 = (String)openTags.peek();
                }
                if (openTag2 == null) continue;
                if (openTag2.equals(tagName)) {
                    openTags.pop();
                    continue;
                }
                throw new InvalidHtmlContentException(openTag2, "missing_close_tag", i, Htmls.subNearbyErrorContent(content, i));
            }
            throw new InvalidHtmlContentException(tagName, "missing_the_greater_than_sign_to_close_tag", i, Htmls.subNearbyErrorContent(content, i));
        }
        while (openTags.size() > 0 && NO_CLOSED_TAGS.contains(openTag = (String)openTags.peek())) {
            openTags.pop();
        }
        openTag = (String)openTags.peek();
        if (openTag != null) {
            throw new InvalidHtmlContentException(openTag, "missing_close_tag", contentLength, "");
        }
    }

    private static String subNearbyErrorContent(String content, int position) {
        return Strings.substringLast(content, position, 120);
    }

    private static int validateCodeContainerTag(String content, int contentLength, int i, String tagName, boolean isScriptTag) {
        boolean startQuote = false;
        boolean startDoubleQuotes = false;
        ++i;
        while (i < contentLength) {
            char ch = content.charAt(i);
            char beforeCh = content.charAt(i - 1);
            if (ch == '\'' && beforeCh != '\\') {
                if (startQuote) {
                    startQuote = false;
                } else if (!startDoubleQuotes) {
                    startQuote = true;
                }
            } else if (ch == '\"' && beforeCh != '\\') {
                if (startDoubleQuotes) {
                    startDoubleQuotes = false;
                } else if (!startQuote) {
                    startDoubleQuotes = true;
                }
            } else if ((!isScriptTag || ch == '>') && !startQuote && !startDoubleQuotes && Strings.endsWith(content, i, tagName)) break;
            ++i;
        }
        return i;
    }
}

