/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.properties.file.io;

import com.tvd12.properties.file.io.Dates;
import com.tvd12.properties.file.io.StringConverter;
import com.tvd12.properties.file.io.Transformer;
import com.tvd12.properties.file.io.ValueConverter;
import com.tvd12.properties.file.util.Logger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SimpleValueConverter
implements ValueConverter {
    protected final Map<Class, Transformer> transformers = this.defaultTransformers();

    @Override
    public <T> T convert(Object value, Class<T> outType) {
        if (value == null) {
            return null;
        }
        Transformer transformer = this.transformers.get(outType);
        if (transformer != null) {
            return (T)transformer.transform(value);
        }
        if (outType.isEnum()) {
            return Enum.valueOf(outType, value.toString());
        }
        return (T)value;
    }

    private Map<Class, Transformer> defaultTransformers() {
        HashMap<Class, Transformer> answer = new HashMap<Class, Transformer>();
        this.addOtherTransformers(answer);
        this.addWrapperTransformers(answer);
        this.addPrimitiveTransformers(answer);
        this.addWrapperArrayTransformers(answer);
        this.addPrimitiveArrayTransformers(answer);
        this.addTwoDimensionsWrapperArrayTransformers(answer);
        this.addTwoDimensionsPrimitiveArrayTransformers(answer);
        return answer;
    }

    protected void addPrimitiveTransformers(Map<Class, Transformer> answer) {
        answer.put(Boolean.TYPE, value -> Boolean.valueOf(value.toString()));
        answer.put(Byte.TYPE, value -> Byte.valueOf(value.toString()));
        answer.put(Character.TYPE, value -> Character.valueOf(StringConverter.stringToChar(value.toString())));
        answer.put(Double.TYPE, value -> Double.valueOf(value.toString()));
        answer.put(Float.TYPE, value -> Float.valueOf(value.toString()));
        answer.put(Integer.TYPE, value -> Integer.valueOf(value.toString()));
        answer.put(Long.TYPE, value -> Long.valueOf(value.toString()));
        answer.put(Short.TYPE, value -> Short.valueOf(value.toString()));
    }

    protected void addWrapperTransformers(Map<Class, Transformer> answer) {
        answer.put(Boolean.class, value -> Boolean.valueOf(value.toString()));
        answer.put(Byte.class, value -> Byte.valueOf(value.toString()));
        answer.put(Character.class, value -> Character.valueOf(StringConverter.stringToChar(value.toString())));
        answer.put(Double.class, value -> Double.valueOf(value.toString()));
        answer.put(Float.class, value -> Float.valueOf(value.toString()));
        answer.put(Integer.class, value -> Integer.valueOf(value.toString()));
        answer.put(Long.class, value -> Long.valueOf(value.toString()));
        answer.put(Short.class, value -> Short.valueOf(value.toString()));
        answer.put(String.class, Object::toString);
    }

    protected void addPrimitiveArrayTransformers(Map<Class, Transformer> answer) {
        answer.put(boolean[].class, value -> StringConverter.stringToPrimitiveBoolArray((String)value));
        answer.put(byte[].class, value -> StringConverter.stringToPrimitiveByteArray((String)value));
        answer.put(char[].class, value -> StringConverter.stringToPrimitiveCharArray((String)value));
        answer.put(double[].class, value -> StringConverter.stringToPrimitiveDoubleArray((String)value));
        answer.put(float[].class, value -> StringConverter.stringToPrimitiveFloatArray((String)value));
        answer.put(int[].class, value -> StringConverter.stringToPrimitiveIntArray((String)value));
        answer.put(long[].class, value -> StringConverter.stringToPrimitiveLongArray((String)value));
        answer.put(short[].class, value -> StringConverter.stringToPrimitiveShortArray((String)value));
    }

    protected void addWrapperArrayTransformers(Map<Class, Transformer> answer) {
        answer.put(Boolean[].class, value -> StringConverter.stringToWrapperBoolArray((String)value));
        answer.put(Byte[].class, value -> StringConverter.stringToWrapperByteArray((String)value));
        answer.put(Character[].class, value -> StringConverter.stringToWrapperCharArray((String)value));
        answer.put(Double[].class, value -> StringConverter.stringToWrapperDoubleArray((String)value));
        answer.put(Float[].class, value -> StringConverter.stringToWrapperFloatArray((String)value));
        answer.put(Integer[].class, value -> StringConverter.stringToWrapperIntArray((String)value));
        answer.put(Long[].class, value -> StringConverter.stringToWrapperLongArray((String)value));
        answer.put(Short[].class, value -> StringConverter.stringToWrapperShortArray((String)value));
        answer.put(String[].class, value -> ((String)value).split(","));
    }

    protected void addOtherTransformers(Map<Class, Transformer> answer) {
        answer.put(Date.class, value -> {
            try {
                return Dates.parse(value.toString());
            }
            catch (Exception e) {
                Logger.print("value: " + value + " is invalid", e);
                return null;
            }
        });
        answer.put(LocalDate.class, value -> {
            try {
                return Dates.parseDate(value.toString(), "yyyy-MM-dd");
            }
            catch (Exception e) {
                Logger.print("value: " + value + " is invalid", e);
                return null;
            }
        });
        answer.put(LocalDateTime.class, value -> {
            try {
                return Dates.parseDateTime(value.toString());
            }
            catch (Exception e) {
                Logger.print("value: " + value + " is invalid", e);
                return null;
            }
        });
        answer.put(Class.class, value -> {
            try {
                return Class.forName(value.toString());
            }
            catch (Exception e) {
                Logger.print("value: " + value + " is invalid", e);
                return null;
            }
        });
    }

    protected void addTwoDimensionsPrimitiveArrayTransformers(Map<Class, Transformer> answer) {
        answer.put(boolean[][].class, value -> StringConverter.stringToPrimitiveBoolArrays((String)value));
        answer.put(byte[][].class, value -> StringConverter.stringToPrimitiveByteArrays((String)value));
        answer.put(char[][].class, value -> StringConverter.stringToPrimitiveCharArrays((String)value));
        answer.put(double[][].class, value -> StringConverter.stringToPrimitiveDoubleArrays((String)value));
        answer.put(float[][].class, value -> StringConverter.stringToPrimitiveFloatArrays((String)value));
        answer.put(int[][].class, value -> StringConverter.stringToPrimitiveIntArrays((String)value));
        answer.put(long[][].class, value -> StringConverter.stringToPrimitiveLongArrays((String)value));
        answer.put(short[][].class, value -> StringConverter.stringToPrimitiveShortArrays((String)value));
    }

    protected void addTwoDimensionsWrapperArrayTransformers(Map<Class, Transformer> answer) {
        answer.put(Boolean[][].class, value -> StringConverter.stringToWrapperBoolArrays((String)value));
        answer.put(Byte[][].class, value -> StringConverter.stringToWrapperByteArrays((String)value));
        answer.put(Character[][].class, value -> StringConverter.stringToWrapperCharArrays((String)value));
        answer.put(Double[][].class, value -> StringConverter.stringToWrapperDoubleArrays((String)value));
        answer.put(Float[][].class, value -> StringConverter.stringToWrapperFloatArrays((String)value));
        answer.put(Integer[][].class, value -> StringConverter.stringToWrapperIntArrays((String)value));
        answer.put(Long[][].class, value -> StringConverter.stringToWrapperLongArrays((String)value));
        answer.put(Short[][].class, value -> StringConverter.stringToWrapperShortArrays((String)value));
        answer.put(String[][].class, value -> StringConverter.stringToStringArrays((String)value));
    }
}

