/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.command.impl;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfoxserver.command.EzyAbstractCommand;
import com.tvd12.ezyfoxserver.command.EzyBroadcastEvent;
import com.tvd12.ezyfoxserver.context.EzyServerContext;
import com.tvd12.ezyfoxserver.context.EzyZoneContext;
import com.tvd12.ezyfoxserver.event.EzyEvent;

public class EzyBroadcastEventImpl
extends EzyAbstractCommand
implements EzyBroadcastEvent {
    private final EzyServerContext context;

    @Override
    public void fire(EzyConstant type, EzyEvent event, boolean catchException) {
        this.logger.debug("broadcast server event: {}", (Object)type);
        this.fireZonesEvent(type, event, catchException);
    }

    protected void fireZonesEvent(EzyConstant type, EzyEvent event, boolean catchException) {
        for (EzyZoneContext zoneContext : this.context.getZoneContexts()) {
            this.fireZoneEvent(zoneContext, type, event, catchException);
        }
    }

    protected void fireZoneEvent(EzyZoneContext ctx, EzyConstant type, EzyEvent event, boolean catchException) {
        if (catchException) {
            try {
                ctx.handleEvent(type, event);
                ctx.broadcast(type, event, true);
            }
            catch (Exception e) {
                ctx.handleException(Thread.currentThread(), e);
            }
        } else {
            ctx.handleEvent(type, event);
            ctx.broadcast(type, event, false);
        }
    }

    public EzyBroadcastEventImpl(EzyServerContext context) {
        this.context = context;
    }
}

